#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TAttrName {
    static constexpr char const JupiterCurrentState[]  = "jupiter_meta/production_current_state";
    static constexpr char const SpyLogCurrentState[]   = "userfeat_meta/long_user_counters_meta/state_production";
    static constexpr char const MetrikaCurrentState[]  = "userfeat_meta/user_counters_lemur_meta/state_for_production";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        const auto &ccfg = TCommonYTConfig::CInstance();
        ARNOLD                                      = "arnold.yt.yandex.net";
        HAHN                                        = "hahn.yt.yandex.net";

        TABLE_EXPORT_ROOT                               = NYTUtils::JoinPath(ccfg.GetStagePath(ccfg.TABLE_EXPORT_ROOT), "disallowed_urls_alert");
        TABLE_EXPORT_DISALLOWED_URLS                    = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "prepared_urls");
        TABLE_EXPORT_DISALLOWED_MEASURED_URLS           = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "measured_urls");
        TABLE_EXPORT_DISALLOWED_MEASURED_FILTERED_URLS  = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "filtered_urls");

        WEBMASTER_VERIFIED_HOSTS            = "//home/webmaster/prod/export/webmaster-hosts";
    }

public:
    TString HAHN;
    TString ARNOLD;

    TString WEBMASTER_VERIFIED_HOSTS;

    TString TABLE_EXPORT_ROOT;
    TString TABLE_EXPORT_DISALLOWED_URLS;
    TString TABLE_EXPORT_DISALLOWED_MEASURED_URLS;
    TString TABLE_EXPORT_DISALLOWED_MEASURED_FILTERED_URLS;
};

} //namespace NWebmaster
