#include <mapreduce/yt/interface/client.h>

#include <util/system/file.h>
#include <util/string/join.h>
#include <util/string/printf.h>
#include <util/thread/pool.h>
#include <util/draft/datetime.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/protobuf/json/proto2json.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/compress.h>
#include <wmconsole/version3/wmcutil/yt/misc.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>
#include <wmconsole/version3/wmcutil/regex.h>

#include <wmconsole/version3/library/jupiter/jupiter.h>

#include "config.h"
#include "task_get_disallowed_urls.h"

namespace NWebmaster {
namespace NDisallowedUrlsAlert {

void LogInfo(const TString& msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NDisallowedUrlsAlert
} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    using namespace NWebmaster;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("GetDisallowedUrls", NDisallowedUrlsAlert::TaskGetDisallowedUrls, "TaskGetDisallowedUrls");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);

    TOpRunner::LogInfo = NDisallowedUrlsAlert::LogInfo;
    TLogger::Instance();
    NYTUtils::DisableLogger();

    return modChooser.Run(modeArgs);
}
