#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TAttrName {
    static constexpr char const DiffSource[]        = "diff_source_current";
    static constexpr char const AcceptanceSource[]  = "acceptance_table";
    static constexpr char const Source[]            = "source_table";
    static constexpr char const SourceBaseTs[]      = "source_base_timestamp";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    static TString MonsterVersion(const TString &table) {
        return table + "-monster";
    }

    TString GetFormatDate(const TString &format) const {
        const struct tm *tm;
        time_t now = time(nullptr);
        tm = localtime(&now);
        return Strftime(format.data(), tm);
    }

    TString GetRunTimestamp() const {
        static TString ts = GetFormatDate("%s");
        return ts;
    }

    TConfig() {
        MR_SERVER_HOST                              = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;

        TABLE_ROOT                                  = TCommonYTConfig::CInstance().TABLE_ROOT;
        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_USER_ROOT                             = TCommonYTConfig::CInstance().TABLE_USER_ROOT;
        TABLE_TEMP_ROOT                             = NYTUtils::JoinPath(TABLE_ROOT, "tmp");

        TABLE_SOURCE_JUPITER_ACCEPTANCE_ROOT        = TCommonYTConfig::CInstance().TABLE_SOURCE_JUPITER_ACCEPTANCE_ROOT;
        TABLE_SOURCE_JUPITER_ROW_COUNT              = 15000000000;
        TABLE_SOURCE_WEBMASTER_HOSTS                = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;
        TABLE_SOURCE_WEBMASTER_HOSTS_ROW_COUNT      = 4000000;
        TABLE_SOURCE_USER_URLS                      = TCommonYTConfig::CInstance().TABLE_SOURCE_USER_URLS;
        TABLE_SOURCE_REL_CANONICAL                  = TCommonYTConfig::CInstance().TABLE_SOURCE_REL_CANONICAL;
        TABLE_SOURCE_FROM_SITEMAP                   = TCommonYTConfig::CInstance().TABLE_SOURCE_FROM_SITEMAP;

        //TABLE_SOURCE_TEST_HOSTS                     = "//home/webmaster/test/sitetree/test-reduced-urls.v2";
        TABLE_TURBO_PAGES                           = NYTUtils::JoinPath(TABLE_ROOT,"import/turbo/turbo_search_urls");
        TABLE_SITETREE_ROOT                         = NYTUtils::JoinPath(TABLE_ROOT, "sitetree");
        TABLE_SITETREE_READY_PREFIX                 = NYTUtils::JoinPath(TABLE_SITETREE_ROOT, "ready-");
        TABLE_SITETREE_REDUCED_URLS                 = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "sitetree/reduced-urls");
        TABLE_SITETREE_REDUCED_URLS_MONSTER         = MonsterVersion(TABLE_SITETREE_REDUCED_URLS);
        TABLE_SITETREE_HOSTS_MONSTERS               = NYTUtils::JoinPath(TABLE_USER_ROOT, "hosts.monsters");
        TABLE_SITETREE_USER_SETTINGS                = NYTUtils::JoinPath(TABLE_USER_ROOT, "sitetree");

        TABLE_SEARCH_ROOT                           = NYTUtils::JoinPath(TABLE_SITETREE_ROOT, "search");
        TABLE_SEARCH_DIFF                           = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "diff.full.acceptance");
        TABLE_SEARCH_ARCHIVE                        = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "archive");
        TABLE_SEARCH_ARCHIVE_INTM                   = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "archive-intm");
        TABLE_SEARCH_ARCHIVE_STATE_ROOT             = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "archives");
        TABLE_SEARCH_HISTORY_FULL                   = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "history.full.new_gone");
        TABLE_SEARCH_HISTORY_WMC                    = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "history.wmc.new_gone.acceptance");
        TABLE_SEARCH_SAMPLES_EXCLUDED               = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "samples.wmc.excluded.last_access.acceptance");
        TABLE_SEARCH_SAMPLES_INSEARCH               = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "samples.wmc.last_access.acceptance");
        TABLE_SEARCH_STORED_ACCEPTANCE              = NYTUtils::JoinPath(TABLE_SEARCH_ROOT, "snapshot.prev.search");
        TABLE_ACCEPTANCE_URLS_FOR_WEBMASTER_SIMPLE_ROOT = NYTUtils::JoinPath(TABLE_ROOT, "acceptance/urls_for_webmaster_simple");

        MONITOR_PERFORMANCE_SUFFIX                  = "production";
    }

public:
    const float OPERATION_WEIGHT = 1.0f;

    TString MR_SERVER_HOST;

    TString TABLE_ROOT;
    TString TABLE_EXPORT_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_USER_ROOT;

    TString TABLE_SOURCE_JUPITER_ACCEPTANCE_ROOT;
    size_t TABLE_SOURCE_JUPITER_ROW_COUNT;
    //TString TABLE_SOURCE_TEST_HOSTS;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    size_t TABLE_SOURCE_WEBMASTER_HOSTS_ROW_COUNT;
    TString TABLE_SOURCE_USER_URLS;
    TString TABLE_SOURCE_REL_CANONICAL;
    TString TABLE_SOURCE_FROM_SITEMAP;

    TString TABLE_TURBO_PAGES;
    TString TABLE_SITETREE_HOSTS_MONSTERS;
    TString TABLE_SITETREE_READY_PREFIX;
    TString TABLE_SITETREE_REDUCED_URLS;
    TString TABLE_SITETREE_ROOT;
    TString TABLE_SITETREE_USER_SETTINGS;
    TString TABLE_SITETREE_REDUCED_URLS_MONSTER;

    TString TABLE_SEARCH_ROOT;
    TString TABLE_SEARCH_DIFF;
    TString TABLE_SEARCH_ARCHIVE_SOURCE;

    TString TABLE_SEARCH_ARCHIVE_INTM;
    TString TABLE_SEARCH_ARCHIVE_STATE_ROOT;
    TString TABLE_SEARCH_ARCHIVE;

    TString TABLE_SEARCH_HISTORY_FULL;
    TString TABLE_SEARCH_HISTORY_WMC;
    TString TABLE_SEARCH_SAMPLES_EXCLUDED;
    TString TABLE_SEARCH_SAMPLES_INSEARCH;
    TString TABLE_SEARCH_STORED_ACCEPTANCE;

    TString TABLE_ACCEPTANCE_URLS_FOR_WEBMASTER_SIMPLE_ROOT;

    TString MONITOR_PERFORMANCE_SUFFIX;
};

} //namespace NWebmaster
