#pragma once

#include <util/generic/singleton.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/map.h>

#include <wmconsole/version3/wmcutil/monitor_client.h>

namespace NWebmaster {

void MonitorPushCheckurlProcessed(const TString &suffix, size_t value);
void MonitorPushCheckurlSpamness(const TString &suffix, double value);
void MonitorPushCrawlerSpreads(const TString &suffix, size_t value);
void MonitorPushHoststat(const TString &suffix, size_t value);
void MonitorPushImportantUrlsProcessed(const TString &suffix, size_t value);
void MonitorPushImportantUrlsUpdated(const TString &suffix, size_t value);
void MonitorPushImportantUrlsUpdateShare(const TString &suffix, const TString &counter, float value);
void MonitorPushJupiterLag(const TString &suffix, time_t accpState, time_t prodState);
void MonitorPushSearchBase(const TString &suffix, size_t historyRecords, size_t historyBytes);
void MonitorPushSitetreeAnomalies(const TString &suffix, const TMap<time_t, TMap<TString, double>> &history);
void MonitorPushSitetrees(const TString &suffix, size_t urls, size_t urlsInSearch, size_t hosts);
void MonitorPushSitetreeSuspiciousTables(const TString &suffix, size_t value);
void MonitorPushXmlSearchMatch(const TString &suffix, double value);

} //namespace NWebmaster
