#include <robot/library/yt/static/command.h>
#include <yql/library/embedded/yql_embedded.h>
#undef LOG_DEBUG
#undef LOG_INFO
#undef LOG_ERROR

#include <wmconsole/version3/wmcutil/log.h>

#include "config.h"
#include "task_monsters.h"

namespace NWebmaster {

using namespace NJupiter;

THolder<NYql::NEmbedded::IOperation> RunYQL(const TString &sql, const TString &operationTitle) {
    NYql::NEmbedded::TOperationFactoryOptions factoryOptions;
    auto factory = NYql::NEmbedded::MakeOperationFactory(factoryOptions);
    NYql::NEmbedded::TOperationOptions operationOptions;
    operationOptions.Title = operationTitle;
    operationOptions.SyntaxVersion = 1;
    auto operation = factory->Run(sql, operationOptions);
    return operation;
}

TStringBuf ServerAlias(const TStringBuf server) {
    return server.Before('.');
}

int TaskMonsters(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr client = NYT::CreateClient(cfg.MR_SERVER_HOST);

    const TString jupiterAcceptanceTable    = cfg.TABLE_SEARCH_STORED_ACCEPTANCE;
    const TString jupiterAcceptanceSource   = GetYtAttr(client, jupiterAcceptanceTable, TAttrName::AcceptanceSource).AsString();

    try {
        if (GetYtAttr(client, cfg.TABLE_SITETREE_HOSTS_MONSTERS, TAttrName::AcceptanceSource).AsString() == jupiterAcceptanceSource) {
            LOG_INFO("monsters, acceptance source is already processed: %s", jupiterAcceptanceSource.data());
            return 0;
        }
    } catch (yexception &e) {
        LOG_WARN("monsters, %s", e.what());
    }

    TString SQL = R"(
        use ${YT};

        insert into `${OUTPUT_TABLE}`
            with truncate
        select Host as key, cast(count(*) as String) as value
        from `${INPUT_TABLE}`
        group by Host
        having count(*) > 320000000
            or sum(length(Path)) > 30000000000
        order by key
    )";

    SubstGlobal(SQL, "${YT}", ServerAlias(cfg.MR_SERVER_HOST));
    SubstGlobal(SQL, "${INPUT_TABLE}", cfg.TABLE_SEARCH_STORED_ACCEPTANCE);
    SubstGlobal(SQL, "${OUTPUT_TABLE}", cfg.TABLE_SITETREE_HOSTS_MONSTERS);

    RunYQL(SQL, "SITETREE monsters (YQL)");

    SetYtAttr(client, cfg.TABLE_SITETREE_HOSTS_MONSTERS, TAttrName::AcceptanceSource, jupiterAcceptanceSource);
    return 0;
}

} //namespace NWebmaster
