#pragma once

#include <Poco/Nullable.h>

#include <util/system/defaults.h>

#include "mirrors_resolver.h"
#include "user_info_map.h"

namespace NWebmaster {

typedef Poco::Tuple<Poco::Int64, std::string, Poco::Nullable<ui32>, Poco::Nullable<Poco::Int64> > THostInfoDB;

struct THostInfo : protected THostInfoDB {
    THostInfo()
        : limit(0),
          dump_to_migration_tbl(false) {
    }

    THostInfo(const THostInfoDB &rhs)
        : THostInfoDB(rhs)
        , limit(0),
          dump_to_migration_tbl(false) {
    }

    const Poco::Int64 &id() const {
        return get<0>();
    }

    const std::string &name() const {
        return get<1>();
    }

    const Poco::Nullable<ui32> &db_limit() const {
        return get<2>();
    }

    const Poco::Nullable<Poco::Int64> &main_user() const {
        return get<3>();
    }

    ui32 limit;
    bool dump_to_migration_tbl;
};

struct THostInfoContainer {
    THostInfoContainer()
        : rank(0)
        , main_user_exists(false) {
    }

    ui32 rank;
    bool main_user_exists;
    std::vector<THostInfo> array;
};

struct THostInfoMap : public std::map<std::string, THostInfoContainer> {
    /** Places host data [id, name, limit, (main)user_id] in map in format "site.com:portnumber"
      *
      */
    void add_host_info(const THostInfo &host_info, const TUserInfoMap &user_info_map);
    bool find_host(const std::string &host, THostInfoMap::iterator &iter, bool force_find_main_user = false);
};

/** Load verified hosts from WebMaster DB
  *
  */
void get_host_info_map(Poco::Data::Session &user_sess, THostInfoMap &res, const TUserInfoMap &user_info_map, TMirrorResolver::Ptr mirrorResolver);

} //namespace NWebmaster
