#pragma once

#include <wmconsole/legacy/util/application.h>

namespace NWebmaster {

class TApplication : public WMCApplication {
public:
    TApplication(void) {}
    ~TApplication(void) override {}

private:

    void defineOptions(OptionSet &options) override {
        WMCApplication::defineOptions(options);
        WMCApplication::defineDbOptions(options);

        options.addOption(
            Option(OP_XML_DB_URLS, "xd",
                   "MySQL xml databases URLs\n"
                   "  Format: <user>[:<password>]@<host>[:<port>]/<dbname>{,<user>[:<password>]@<host>[:<port>]/<dbname>}\n"
            )
                .required(true)
                .repeatable(false)
                .argument("<url-list>")
                .binding(OP_XML_DB_URLS)
        );

        options.addOption(
            Option(OP_YT_CLUSTER, "s", "YT source cluster\n")
                .required(true)
                .repeatable(false)
                .argument("<cluster-name>")
                .binding(OP_YT_CLUSTER)
        );

        options.addOption(
            Option(OP_YT_ROOT, "e", "YT export root path\n")
                .required(true)
                .repeatable(false)
                .argument("<export-path>")
                .binding(OP_YT_ROOT)
        );

        options.addOption(
            Option(OP_XML_LIMITS_TABLE, "i", "Xml limits source table\n")
                .required(true)
                .repeatable(false)
                .argument("<source-table>")
                .binding(OP_XML_LIMITS_TABLE)
        );


    }

    std::vector<std::string> getXmlDbUrls() const {
        std::vector<std::string> hostUrls;
        if(config().hasOption(OP_XML_DB_URLS)) {
            std::string hu = config().getString(OP_XML_DB_URLS);
            parseString(hu.c_str(), ',', hostUrls);
        }
        return hostUrls;
    }

    int doMain(const std::vector<std::string> &args) override;

private:
    static const std::string OP_XML_DB_URLS;
    static const std::string OP_YT_CLUSTER;
    static const std::string OP_YT_ROOT;
    static const std::string OP_XML_LIMITS_TABLE;
};

} //namespace NWebmaster
