#pragma once

#include <map>

#include <Poco/Tuple.h>

namespace NWebmaster {

typedef Poco::Int64 TUserId;
typedef Poco::Tuple<TUserId, Poco::Int64> TUserInfoDB;

struct TUserInfo : TUserInfoDB {
    TUserInfo() : limit(0), db_limit(0) {}
    Poco::Int64 limit;
    Poco::Int64 db_limit;
};

typedef std::map<TUserId, TUserInfo> TUserIdMap;

struct TUserInfoMap : public std::map<size_t, TUserIdMap> {
    void add_user(size_t db_num, const TUserInfoDB &info);
    const TUserInfo *find_user_id(TUserId id) const;
    TUserInfo *find_user_id(TUserId id);
    size_t users_count() const;
};

} //namespace NWebmaster
