#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/legacy/util/logger.h>

#include "host_processor.h"
#include "mirrors_resolver.h"

Poco::Logger &logger() {
    static Poco::Logger &instance(Poco::Logger::get("XmlLimits"));
    return instance;
}

Y_UNIT_TEST_SUITE(TXmlLimitsTest) {
    Y_UNIT_TEST(IsSubDomain) {
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("https://www.kassir.ru", "https://kassir.ru"), 1);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("www.kassir.ru", "kassir.ru"), 1);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("kassir.ru", "kassir.ru"), 1);

        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("https://www.kassir.ru", "https://kassir.com"), 0);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("https://www.kassir.ru", "kassir.ru"), 0);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("https://kassir.ru", "kassir.ru"), 0);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("www.kassir.ru", "https://kassir.ru"), 0);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("vkassir.ru", "kassir.ru"), 0);
        UNIT_ASSERT_EQUAL(NWebmaster::THostProcessor::isSubdomain("kassir.ru", "kassir.com"), 0);
    }
}
