#include <Poco/Data/MySQL/Connector.h>

#include "xml_holder.h"

namespace NWebmaster {

TXmlHolder &TXmlHolder::instance() {
    static TXmlHolder g_instance;
    return g_instance;
}

void TXmlHolder::init(const std::string &user_db, const std::vector<std::string> &xml_db) {
    user_db_conn_str = check_and_get_conn_str(user_db);
    for (const std::string &host_db_str : xml_db) {
        host_db_conn_str.push_back(check_and_get_conn_str(host_db_str));
    }
    temp_session = session();
}

std::string TXmlHolder::check_and_get_conn_str(const std::string &db_str) {
    NWebmaster::MySQLUrl db_url(db_str);
    return db_url.getConnectionString();
}

WMCSession::Ptr TXmlHolder::session() const {
    WMCSession::Ptr res(new WMCSession(Poco::Data::MySQL::Connector::KEY, user_db_conn_str, host_db_conn_str));
    return res;
}

size_t TXmlHolder::getHostDbCount() const {
    return host_db_conn_str.size();
}

size_t TXmlHolder::getHostDbId(const std::string &hostname) const {
    return temp_session->getHostDbId(hostname);
}

} //namespace NWebmaster
