#pragma once

#include <string>
#include <vector>

#include <util/generic/noncopyable.h>

#include <wmconsole/legacy/util/session.h>

namespace NWebmaster {

//-----------------------------------------------------------------------------------
class TXmlHolder : public TNonCopyable {
public:
    static TXmlHolder &instance();

    void init(const std::string &user_db, const std::vector<std::string> &host_db);

    WMCSession::Ptr session() const;

    size_t getHostDbCount() const;
    size_t getHostDbId(const std::string &hostname) const;

private:
    TXmlHolder() { }

    std::string check_and_get_conn_str(const std::string &db_str);

    WMCSession::Ptr temp_session;
    std::string user_db_conn_str;
    std::vector<std::string> host_db_conn_str;
};

} //namespace NWebmaster
