#pragma once

#include <util/datetime/base.h>
#include <util/generic/singleton.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TConfig {
    TConfig() {
        MR_SERVER_HOST_SPYLOG               = "arnold.yt.yandex.net";

        TABLE_TEMP_ROOT                     = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_TEMP_ROOT, "links");
        TABLE_LINKS_ROOT                    = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "links");

        TABLE_VISITS_ROOT                   = NYTUtils::JoinPath(TABLE_LINKS_ROOT, "broken_visits");
        TABLE_VISITS_SOURCE_ROOT            = NYTUtils::JoinPath(TABLE_VISITS_ROOT, "sources");
        TABLE_VISITS_SNAPSHOT               = NYTUtils::JoinPath(TABLE_VISITS_ROOT, "snapshot");
    }

public:

public:
    static TConfig& Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig& CInstance() {
        return Instance();
    }

    static constexpr const char *FORMAT     = "%Y-%m-%d";
    static const size_t STORE_PERIOD_DAYS   = 14;

    TString MR_SERVER_HOST_SPYLOG;

    TString TABLE_TEMP_ROOT;
    TString TABLE_LINKS_ROOT;

    TString TABLE_VISITS_ROOT;
    TString TABLE_VISITS_SOURCE_ROOT;
    TString TABLE_VISITS_SNAPSHOT;
};

} //namespace NWebmaster
