#pragma once

#include <util/datetime/base.h>
#include <util/generic/singleton.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

const static int PREPARAT_SHARD_COUNT           = 16;
const static int PREPRARAT_SWITCH_PERIOD_DAYS   = 9;

struct TConfig {
    TConfig() {
        TABLE_TEMP_ROOT                     = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_TEMP_ROOT, "links");
        TABLE_LINKS_ROOT                    = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "links");

        TABLE_SNAPSHOT_TEMP_PREFIX          = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "snapshot");

        TABLE_SHARD_EXTRACTED_INT           = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "extracted_int");
        TABLE_SHARD_EXTRACTED_EXT           = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "extracted_ext");
        TABLE_SHARD_EXT_HOSTS               = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "exthosts");
        TABLE_SHARD_SUBREPORT               = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "subreport");
        TABLE_SHARD_SUBREPORT_EXT_HOSTS     = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "subreport_exthosts");

        TABLE_SHARD_ARCHIVE_INT             = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "arc_int");
        TABLE_SHARD_ARCHIVE_EXT             = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "arc_ext");
        TABLE_SHARD_TOP_INT                 = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "top_int");
        TABLE_SHARD_TOP_EXT                 = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "top_ext");
        TABLE_SHARD_NEW_INT                 = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "new_int");
        TABLE_SHARD_NEW_EXT                 = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "new_ext");
        TABLE_SHARD_GONE_INT                = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "gone_int");
        TABLE_SHARD_GONE_EXT                = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "gone_ext");
        TABLE_SHARD_TOP_NEW_EXT             = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "top_new_ext");
        TABLE_SHARD_TOP_GONE_EXT            = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "top_gone_ext");
        TABLE_SHARD_SUBREPORT_NEW_PHASE1    = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "new_hosts");
        TABLE_SHARD_SUBREPORT_GONE_PHASE1   = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "gone_hosts");
        TABLE_SHARD_SUBREPORT_NEW           = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "subreport_new");
        TABLE_SHARD_SUBREPORT_GONE          = NYTUtils::JoinPath(TABLE_TEMP_ROOT, "subreport_gone");

        TABLE_SNAPSHOT_PREFIX               = NYTUtils::JoinPath(TABLE_LINKS_ROOT, "snapshots");

        TABLE_DONE_ROOT                     = NYTUtils::JoinPath(TABLE_LINKS_ROOT, "done");
        TABLE_READY_REPORT                  = NYTUtils::JoinPath(TABLE_DONE_ROOT, "report");
        TABLE_READY_ARCHIVE_INT             = NYTUtils::JoinPath(TABLE_DONE_ROOT, "arc_int");
        TABLE_READY_ARCHIVE_EXT             = NYTUtils::JoinPath(TABLE_DONE_ROOT, "arc_ext");
        TABLE_READY_TOP_INT                 = NYTUtils::JoinPath(TABLE_DONE_ROOT, "top_int");
        TABLE_READY_TOP_EXT                 = NYTUtils::JoinPath(TABLE_DONE_ROOT, "top_ext");
        TABLE_READY_TOP_NEW_EXT             = NYTUtils::JoinPath(TABLE_DONE_ROOT, "top_new_ext");
        TABLE_READY_TOP_GONE_EXT            = NYTUtils::JoinPath(TABLE_DONE_ROOT, "top_gone_ext");

        TABLE_INTERMEDIATE_ROOT             = NYTUtils::JoinPath(TABLE_DONE_ROOT, "intermediate_$ts");
        TABLE_INTERMEDIATE_REPORT           = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "report");
        TABLE_INTERMEDIATE_ARCHIVE_INT      = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "arc_int");
        TABLE_INTERMEDIATE_ARCHIVE_EXT      = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "arc_ext");
        TABLE_INTERMEDIATE_TOP_INT          = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "top_int");
        TABLE_INTERMEDIATE_TOP_EXT          = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "top_ext");
        TABLE_INTERMEDIATE_TOP_NEW_EXT      = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "top_new_ext");
        TABLE_INTERMEDIATE_TOP_GONE_EXT     = NYTUtils::JoinPath(TABLE_INTERMEDIATE_ROOT, "top_gone_ext");
    }

public:
    static const TString MSG_APPLICATION_NAME;
    static const TString MSG_APPLICATION_VERSION;

public:
    static TConfig& Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig& CInstance() {
        return Instance();
    }

    TString TABLE_TEMP_ROOT;
    TString TABLE_LINKS_ROOT;

    TString TABLE_SHARD_EXTRACTED_INT;
    TString TABLE_SHARD_EXTRACTED_EXT;
    TString TABLE_SHARD_EXT_HOSTS;
    TString TABLE_SHARD_SUBREPORT;
    TString TABLE_SHARD_SUBREPORT_EXT_HOSTS;
    TString TABLE_SHARD_ARCHIVE_INT;
    TString TABLE_SHARD_ARCHIVE_EXT;
    TString TABLE_SHARD_TOP_INT;
    TString TABLE_SHARD_TOP_EXT;
    TString TABLE_SHARD_NEW_INT;
    TString TABLE_SHARD_NEW_EXT;
    TString TABLE_SHARD_GONE_INT;
    TString TABLE_SHARD_GONE_EXT;
    TString TABLE_SHARD_TOP_NEW_EXT;
    TString TABLE_SHARD_TOP_GONE_EXT;
    TString TABLE_SHARD_SUBREPORT_NEW_PHASE1;
    TString TABLE_SHARD_SUBREPORT_GONE_PHASE1;
    TString TABLE_SHARD_SUBREPORT_NEW;
    TString TABLE_SHARD_SUBREPORT_GONE;

    TString TABLE_INTERMEDIATE_ROOT;
    TString TABLE_INTERMEDIATE_REPORT;
    TString TABLE_INTERMEDIATE_ARCHIVE_INT;
    TString TABLE_INTERMEDIATE_ARCHIVE_EXT;
    TString TABLE_INTERMEDIATE_TOP_INT;
    TString TABLE_INTERMEDIATE_TOP_EXT;
    TString TABLE_INTERMEDIATE_TOP_NEW_EXT;
    TString TABLE_INTERMEDIATE_TOP_GONE_EXT;

    TString TABLE_DONE_ROOT;
    TString TABLE_READY_REPORT;
    TString TABLE_READY_ARCHIVE_INT;
    TString TABLE_READY_ARCHIVE_EXT;
    TString TABLE_READY_TOP_INT;
    TString TABLE_READY_TOP_EXT;
    TString TABLE_READY_TOP_NEW_EXT;
    TString TABLE_READY_TOP_GONE_EXT;

    TString TABLE_SNAPSHOT_PREFIX;
    TString TABLE_SNAPSHOT_TEMP_PREFIX;
};

} //namespace NWebmaster
