#include <mapreduce/yt/interface/client.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>

#include "config.h"
#include "task_cleanup.h"
#include "task_merge.h"
#include "task_preparat.h"
#include "task_snapshot.h"
#include "task_switch.h"
#include "workflow.h"
#include "utils.h"

namespace NWebmaster {

void LogInfo(const TString &msg) {
    LOG_INFO("%s", msg.data());
}

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TModChooser modChooser;
    modChooser.AddMode("Cleanup", TaskCleanup, "Cleanup");
    modChooser.AddMode("Snapshot", TaskSnapshot, "TaskSnapshot");
    modChooser.AddMode("Switch", TaskSwitch, "Switch");
    modChooser.AddMode("Preparat", TaskPreparat, "Preparat");
    modChooser.AddMode("Merge", TaskMerge, "Merge");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());

    TCustomYTEnvironment::Instance().Init(envRoot);
    TLogger::Instance();
    NYTUtils::DisableLogger();
    TOpRunner::LogInfo = LogInfo;

    return modChooser.Run(modeArgs);
}
