#include <util/thread/pool.h>

#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/regex.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"
#include "utils.h"
#include "task_cleanup.h"

namespace NWebmaster {

int TaskCleanup(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr client = NYT::CreateClient(TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER);

    NYTUtils::CreatePath(client, cfg.TABLE_DONE_ROOT);

    TOpRunner(client)
        //.DropByPrefix(config.TABLE_READY_ARCHIVE_INT)
        //.DropByPrefix(config.TABLE_READY_ARCHIVE_EXT)

        .DropByPrefix(cfg.TABLE_SHARD_EXTRACTED_INT)
        .DropByPrefix(cfg.TABLE_SHARD_EXTRACTED_EXT)
        .DropByPrefix(cfg.TABLE_SHARD_EXT_HOSTS)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT_EXT_HOSTS)

        .DropByPrefix(cfg.TABLE_SHARD_ARCHIVE_INT)
        .DropByPrefix(cfg.TABLE_SHARD_ARCHIVE_EXT)
        .DropByPrefix(cfg.TABLE_SHARD_TOP_INT)
        .DropByPrefix(cfg.TABLE_SHARD_TOP_EXT)

        .DropByPrefix(cfg.TABLE_SHARD_NEW_INT)
        .DropByPrefix(cfg.TABLE_SHARD_GONE_INT)
        .DropByPrefix(cfg.TABLE_SHARD_NEW_EXT)
        .DropByPrefix(cfg.TABLE_SHARD_GONE_EXT)

        .DropByPrefix(cfg.TABLE_SHARD_TOP_NEW_EXT)
        .DropByPrefix(cfg.TABLE_SHARD_TOP_GONE_EXT)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT_NEW_PHASE1)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT_GONE_PHASE1)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT_NEW)
        .DropByPrefix(cfg.TABLE_SHARD_SUBREPORT_GONE)
    ;

    TDeque<TString> snapshots;
    GetTableListOnly(client, cfg.TABLE_SNAPSHOT_PREFIX, snapshots);
    std::sort(snapshots.begin(), snapshots.end(), std::greater<TString>());

    for (size_t i = 2; i < snapshots.size(); i++) {
        //TOpRunner(client).Drop(snapshots[i]);
        LOG_INFO("snapshot %s dropped (dry-run)", snapshots[i].data());
    }

    return 0;
}

} //namespace NWebmaster
