#pragma once

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"
#include "utils.h"

namespace NWebmaster {

struct TSnapshot {
    TSnapshot(time_t timestamp)
        : Timestamp(timestamp)
        , Path(NYTUtils::JoinPath(TConfig::CInstance().TABLE_SNAPSHOT_PREFIX, ToString(timestamp)))
    {
    }

    const TString & GetPath() const {
        return Path;
    }

    const TString GetShardPath(int shardNo) const {
        return NYTUtils::JoinPath(Path, GetShardName(shardNo));
    }

public:
    time_t Timestamp = 0;
    const TString Path;
};

int TaskSnapshot(int, const char **);

} // namespace NWebmaster
