#pragma once

#include <util/generic/deque.h>
#include <util/generic/hash.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/owners.h>

namespace NWebmaster {

NYT::TRichYPath DebugPath(const TString& path);
ui64 GetIks(const THashMap<TString, ui64> &HostsIks, const TString &host, TAnsipamOwnerCanonizer &Owners);
TString GetShardName(int shardNo);
void GetTableListOnly(NYT::IClientBasePtr client, const TString &path, TDeque<TString> &tables);
TString GetTld(const TString &domain);
void LoadIks(NYT::IClientBasePtr client, THashMap<TString, ui64> &hostsIks);

} // namespace NWebmaster
