#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>

namespace NWebmaster {

enum ERuleSource {
    E_RULE_WHO,
    E_RULE_WHAT,
    E_RULE_WHERE,
    E_RULE_HOW,
};

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;

        MR_SERVER_HOST                  = "hahn.yt.yandex.net";

        TABLE_SOURCE_FEMIDA_ROOT            = "//home/femida/cv/daily";

        TABLE_SEOCHECK_ROOT                 = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "seocheck");
        TABLE_SEOCHECK_CONFIG_ROOT          = NYTUtils::JoinPath(TABLE_SEOCHECK_ROOT, "config");
        TABLE_SEOCHECK_CONFIG_WHO           = NYTUtils::JoinPath(TABLE_SEOCHECK_CONFIG_ROOT, "who");
        TABLE_SEOCHECK_CONFIG_WHAT          = NYTUtils::JoinPath(TABLE_SEOCHECK_CONFIG_ROOT, "what");
        TABLE_SEOCHECK_CONFIG_HOW           = NYTUtils::JoinPath(TABLE_SEOCHECK_CONFIG_ROOT, "how");
        TABLE_SEOCHECK_CONFIG_WHERE         = NYTUtils::JoinPath(TABLE_SEOCHECK_CONFIG_ROOT, "where");
        TABLE_SEOCHECK_PROCESSED_ROOT       = NYTUtils::JoinPath(TABLE_SEOCHECK_ROOT, "processed");
        TABLE_SEOCHECK_PROCESSED_HITS       = NYTUtils::JoinPath(TABLE_SEOCHECK_PROCESSED_ROOT, "hits");
        TABLE_SEOCHECK_PROCESSED_TABLES     = NYTUtils::JoinPath(TABLE_SEOCHECK_PROCESSED_ROOT, "tables");
        TABLE_SEOCHECK_PROCESSED_SNAPSHOT   = NYTUtils::JoinPath(TABLE_SEOCHECK_PROCESSED_ROOT, "snapshot");
        TABLE_SEOCHECK_UPDATES_ROOT         = NYTUtils::JoinPath(TABLE_SEOCHECK_ROOT, "updates");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;
    TString MR_SERVER_HOST;
    TString TABLE_SOURCE_FEMIDA_ROOT;
    TString TABLE_SEOCHECK_ROOT;
    TString TABLE_SEOCHECK_CONFIG_ROOT;
    TString TABLE_SEOCHECK_CONFIG_WHO;
    TString TABLE_SEOCHECK_CONFIG_WHAT;
    TString TABLE_SEOCHECK_CONFIG_HOW;
    TString TABLE_SEOCHECK_CONFIG_WHERE;
    TString TABLE_SEOCHECK_PROCESSED_ROOT;
    TString TABLE_SEOCHECK_PROCESSED_HITS;
    TString TABLE_SEOCHECK_UPDATES_ROOT;
    TString TABLE_SEOCHECK_PROCESSED_TABLES;
    TString TABLE_SEOCHECK_PROCESSED_SNAPSHOT;
};

} //namespace NWebmaster
