#!/usr/bin/env python

import json
import sys
from collections import defaultdict
import pandas as pd

df = pd.DataFrame()
data = defaultdict(list)

for line in open(sys.argv[1], encoding="utf-8"):
    obj = json.loads(line)
    for key in obj:
        data[key].append(obj[key])

train = pd.DataFrame.from_dict(data)
train.index.name = "row"
train.to_csv(sys.argv[1].replace(".json", ".tsv"), encoding="utf-8", sep="\t", index=False)
