#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/library/conf/yt.h>

namespace NWebmaster {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;
        MR_SERVER_HOST                       = "arnold.yt.yandex.net";

        TABLE_SAMOVAR_ROOT                   = "//home/webmaster/prod/samovar";
        TABLE_SAMOVAR_STATE_ROOT             = "//home/webmaster/prod/samovar/SitemapsStateExport";
        TABLE_HOST_RELATED_ROOT              = NYTUtils::JoinPath(TABLE_SAMOVAR_ROOT, "HostDataToWebmasterExport");
        TABLE_DATA_ROOT                      = NYTUtils::JoinPath(TABLE_SAMOVAR_ROOT, "SitemapDataToWebmasterExport");
        TABLE_EXPORT_ROOT                    = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "sitemap");
        TABLE_HOST_RELATED_SITEMAP_SNAPSHOT  = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "HostRelatedSitemapsSnapshot");
        TABLE_SITEMAP_SNAPSHOT               = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "sitemap-snapshot");
        TABLE_SITEMAP_WITH_HOST_SNAPSHOT     = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "sitemap-with-host-snapshot");
        TABLE_SITEMAP_PROBLEMS               = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "problems");
        TABLE_SITEMAP_CHANGES_ROOT           = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "changes");
        TABLE_SOURCE_WEBMASTER_HOSTS         = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "export/webmaster-hosts");
        TABLE_TEMP_MIRRORS_REVERSED          = "//home/webmaster/prod/tmp/sitemap-mirrors-reversed";
        TABLE_TEMP_PROCESSED_EXPORT          = "//home/webmaster/prod/tmp/sitemap-processed-export";
    }

public:
    TString MR_SERVER_HOST;
    TString TABLE_SAMOVAR_ROOT;
    TString TABLE_SAMOVAR_STATE_ROOT;
    TString TABLE_HOST_RELATED_ROOT;
    TString TABLE_DATA_ROOT;
    TString TABLE_EXPORT_ROOT;
    TString TABLE_HOST_RELATED_SITEMAP_SNAPSHOT;
    TString TABLE_SITEMAP_SNAPSHOT;
    TString TABLE_SITEMAP_WITH_HOST_SNAPSHOT;
    TString TABLE_SITEMAP_PROBLEMS;
    TString TABLE_SITEMAP_CHANGES_ROOT;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    TString TABLE_TEMP_MIRRORS_REVERSED;
    TString TABLE_TEMP_PROCESSED_EXPORT;
};

} //namespace NWebmaster
