#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/wmcutil/config_base.h>

#include <wmconsole/version3/library/conf/yt.h>

namespace NWebmaster {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        // const TProdYTEnvironment prodEnv;
        auto &prodEnv=TCommonYTConfig::CInstance();

        ATTR_UPDATE_SOURCE                              = "update_source";
        ATTR_UPDATE_TIME                                = "update_time";
        ATTR_UPLOAD_TS                                  = "upload_ts";
        ATTR_UPLOAD_TIME                                = "upload_time";
        ATTR_CREATE_TIME                                = "creation_time";
        ATTR_UPDATE_SPRAV_TS                            = "_cooking_start_time";

        MR_SERVER_HOST                                  = "arnold.yt.yandex.net";
        MR_SERVER_HOST_MOBILE_APPS                      = "arnold.yt.yandex.net";
        MR_SERVER_HOST_SPRAV                            = "hahn.yt.yandex.net";
        MR_SERVER_HOST_ALICE                            = "hahn.yt.yandex.net";
        MR_SERVER_HOST_SHOP_HOSTS                       = "hahn.yt.yandex.net";
        MR_SERVER_HOST_RADAR                            = "hahn.yt.yandex.net";
        MR_SERVER_HOST_USLUGI                           = "hahn.yt.yandex.net";
        MR_SERVER_HOST_MARKET                           = "hahn.yt.yandex.net";
        MR_SERVER_HOST_VERTICAL_SHARE                   = "hahn.yt.yandex.net";
        MR_SERVER_HOST_SNIPPET_PIC                      = "arnold.yt.yandex.net";
        MR_SERVER_HOST_NEWS                             = "arnold.yt.yandex.net";

        TABLE_SOURCE_MOBILE_APPS                        = "//home/shinyserp/qdsaas/deploy_production";
        TABLE_SOURCE_SPRAV                              = "//home/sprav/altay/prod/snapshot/company";
        TABLE_SOURCE_ALICE                              = "//home/paskills/skills/stable";
        TABLE_SOURCE_DIRECT                             = "//home/direct/export/webmaster/webmaster_domains";
        TABLE_SOURCE_MARKET                             = "//home/market/production/pers-grade/tables/shop_rating/current";
        TABLE_SOURCE_VERTICAL_SHARE                     = "//home/goods/export/ugc/saas/shops/stat/current";
        TABLE_SOURCE_METRIKA                            = "//home/webmaster/prod/searchqueries/user_sessions/reference/metrika";
        TABLE_SOURCE_RADAR                              = "//home/radar_top_sites/production/export/domain_markup";
        TABLE_SOURCE_SNIPPET_PIC                        = "//home/shinyserp/snippets/image_snippet/v2/imagesinsnippets";

        TABLE_SERVICES_ROOT                             = NYTUtils::JoinPath(prodEnv.TABLE_ROOT, "siteservices");

        TABLE_SERVICES_PREP_ROOT                        = NYTUtils::JoinPath(TABLE_SERVICES_ROOT, "sources");
        TABLE_SERVICES_PREP_MOBILE_APPS                 = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "mobileApps");
        TABLE_SERVICES_PREP_ALICE                       = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "alice");
        TABLE_SERVICES_PREP_SPRAV                       = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "sprav");
        TABLE_SERVICES_PREP_SPRAV_INTERN                = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "sprav_intern");
        TABLE_SERVICES_PREP_SHOP_HOSTS                  = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "shop_hosts");
        TABLE_SERVICES_PREP_DIRECT                      = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "direct");
        TABLE_SERVICES_PREP_MARKET                      = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "market");
        TABLE_SERVICES_PREP_VERTICAL_SHARE              = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "vertical_share");
        TABLE_SERVICES_PREP_METRIKA                     = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "metrika");
        TABLE_SERVICES_PREP_SNIPPET_PIC                 = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "snippet_pic");
        TABLE_SERVICES_PREP_NEWS                        = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "news");
        TABLE_SERVICES_PREP_RADAR                       = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "radar");
        TABLE_SERVICES_PREP_USLUGI                      = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "uslugi");

        TABLE_SERVICES_TMP_MARKET                       = NYTUtils::JoinPath(TABLE_SERVICES_PREP_ROOT, "tmp-market");

        TABLE_SERVICES_EXPORT_RU                        = NYTUtils::JoinPath(TABLE_SERVICES_ROOT, "services");

        TABLE_QUALITY_ROOT                              = NYTUtils::JoinPath(TABLE_SERVICES_ROOT, "quality");
        TABLE_QUALITY_RIVALS_ROOT                       = NYTUtils::JoinPath(TABLE_QUALITY_ROOT, "rivals");
        TABLE_QUALITY_RIVALS_SPYLOG                     = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "spylog");
        TABLE_QUALITY_RIVALS_SG                         = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "similargroup");
        TABLE_QUALITY_RIVALS_GENERATED                  = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "generated");

        TABLE_QUALITY_MODELS_ROOT                       = NYTUtils::JoinPath(TABLE_QUALITY_ROOT, "models");
        TABLE_QUALITY_MODELS_SG_FILTERED                = NYTUtils::JoinPath(TABLE_QUALITY_MODELS_ROOT, "sg-filtered");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;
    TString MR_SERVER_HOST;
    TString MR_SERVER_HOST_SPRAV;
    TString MR_SERVER_HOST_SHOP_HOSTS;
    TString MR_SERVER_HOST_ALICE;
    TString MR_SERVER_HOST_MOBILE_APPS;
    TString MR_SERVER_HOST_RADAR;
    TString MR_SERVER_HOST_USLUGI;
    TString MR_SERVER_HOST_MARKET;
    TString MR_SERVER_HOST_VERTICAL_SHARE;
    TString MR_SERVER_HOST_SNIPPET_PIC;
    TString MR_SERVER_HOST_NEWS;

    TString ATTR_UPDATE_SOURCE;
    TString ATTR_UPDATE_TIME;
    TString ATTR_UPLOAD_TS;
    TString ATTR_UPLOAD_TIME;
    TString ATTR_CREATE_TIME;
    TString ATTR_UPDATE_SPRAV_TS;

    TString TABLE_SOURCE_MOBILE_APPS;
    TString TABLE_SOURCE_SPRAV;
    TString TABLE_SOURCE_ALICE;
    TString TABLE_SOURCE_DIRECT;
    TString TABLE_SOURCE_MARKET;
    TString TABLE_SOURCE_VERTICAL_SHARE;
    TString TABLE_SOURCE_METRIKA;
    TString TABLE_SOURCE_RADAR;
    TString TABLE_SOURCE_SNIPPET_PIC;

    TString TABLE_SERVICES_ROOT;
    TString TABLE_SERVICES_EXPORT_RU;
    TString TABLE_SERVICES_EXPORT_KUUB;

    TString TABLE_SERVICES_PREP_ROOT;
    TString TABLE_SERVICES_PREP_SEARCHBASE;
    TString TABLE_SERVICES_PREP_MOBILE_APPS;
    TString TABLE_SERVICES_PREP_ALICE;
    TString TABLE_SERVICES_PREP_SPRAV;
    TString TABLE_SERVICES_PREP_SPRAV_INTERN;
    TString TABLE_SERVICES_PREP_SHOP_HOSTS;
    TString TABLE_SERVICES_PREP_DIRECT;
    TString TABLE_SERVICES_PREP_MARKET;
    TString TABLE_SERVICES_PREP_VERTICAL_SHARE;
    TString TABLE_SERVICES_PREP_SNIPPET_PIC;
    TString TABLE_SERVICES_PREP_NEWS;
    TString TABLE_SERVICES_PREP_METRIKA;
    TString TABLE_SERVICES_PREP_RADAR;
    TString TABLE_SERVICES_PREP_USLUGI;

    TString TABLE_SERVICES_TMP_MARKET;

    TString TABLE_QUALITY_ROOT;
    TString TABLE_QUALITY_RIVALS_ROOT;
    TString TABLE_QUALITY_RIVALS_SPYLOG;
    TString TABLE_QUALITY_RIVALS_SG;
    TString TABLE_QUALITY_RIVALS_GENERATED;

    TString TABLE_QUALITY_MODELS_ROOT;
    TString TABLE_QUALITY_MODELS_SG_FILTERED;
};

} //namespace NWebmaster
