#include <util/string/cast.h>

#include <wmconsole/version3/wmcutil/url.h>

#include "import_util.h"

namespace NWebmaster{

TString JsonToString(const NJson::TJsonValue &value) {
    TStringStream out;
    NJson::WriteJson(&out, &value);
    return out.ReadAll();
}

NJson::TJsonValue StringToJson(const TString &data) {
    TStringStream in;
    in << data;
    NJson::TJsonValue value;
    NJson::ReadJsonTree(&in, &value);
    return value;
}

TString GetOwner(const TString &str) {
    TString owner = ToString(GetHost(CutHttpPrefix(StripString(str))));
    if (owner.StartsWith("www.")) {
        owner = owner.substr(4);
    }
    return owner;
}

}//namespace NWebmaster
