#include <util/stream/output.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include <wmconsole/version3/processors/siteservices/conf/config.h>
#include <wmconsole/version3/library/conf/yt.h>

#include "task_about_alice_skill.h"
#include "task_about_mobile.h"
#include "task_about_shop_hosts.h"
#include "task_about_sprav.h"
#include "task_merge.h"
#include "task_about_direct_hosts.h"
#include "task_about_market_hosts.h"
#include "task_about_metrika_hosts.h"
#include "task_about_radar_hosts.h"
#include "task_about_uslugi_hosts.h"
#include "task_about_snippet_pic_hosts.h"
#include "task_about_news_hosts.h"
#include "task_about_vertical_share.h"

namespace NWebmaster {

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;

    TCustomYTEnvironment::Instance().Init("prod");

    TModChooser modChooser;
    modChooser.AddMode("Merge", TaskMerge, "Merge site-services");

    modChooser.AddMode("Mobile", AboutMobile, "Prepare mobile data");
    modChooser.AddMode("Alice", AboutAliceSkill, "Prepare alice skills data");
    modChooser.AddMode("Sprav", AboutSprav, "Prepare data from spravochnik");
    modChooser.AddMode("ShopHosts", AboutShopHosts, "Prepare shop hosts data");
    modChooser.AddMode("DirectHosts", AboutDirectHosts, "Prepare direct hosts");
    modChooser.AddMode("MarketHosts", AboutMarketHosts, "Prepare market hosts");
    modChooser.AddMode("MetrikaHosts", AboutMetrikaHosts, "Prepare metrika hosts");
    modChooser.AddMode("RadarHosts", AboutRadarHosts, "Prepare radar hosts");
    modChooser.AddMode("UslugiHosts", AboutUslugiHosts, "Prepare uslugi hosts");
    modChooser.AddMode("SnippetPictureHost", AboutSnippetPictureHost, "Prepare host with pictures in snippet");
    modChooser.AddMode("NewsHosts", NewsHosts, "Prepare news hosts");
    modChooser.AddMode("VerticalShare", AboutVerticalShare, "Prepare vertical share hosts");

    return modChooser.Run(argc, argv);
}
