#include <util/draft/date.h>
#include <util/generic/set.h>
#include <util/thread/pool.h>

#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/table.h>
#include <yql/library/embedded/yql_embedded.h>
#include <kernel/urlnorm/normalize.h>

#undef LOG_DEBUG
#undef LOG_INFO
#undef LOG_ERROR

#include <wmconsole/version3/processors/siteservices/protos/sources.pb.h>
#include <wmconsole/version3/processors/siteservices/protos/services.pb.h>
#include <wmconsole/version3/processors/siteservices/conf/config.h>
#include <wmconsole/version3/wmcutil/yt/transfer_manager.h>

#include "import_util.h"
#include "task_about_shop_hosts.h"

namespace NWebmaster {
using namespace NJupiter;

THolder<NYql::NEmbedded::IOperation> RunYQL(const TString &sql, const TString &operationTitle) {
    NYql::NEmbedded::TOperationFactoryOptions factoryOptions;
    auto factory = NYql::NEmbedded::MakeOperationFactory(factoryOptions);
    NYql::NEmbedded::TOperationOptions operationOptions;
    operationOptions.Title = operationTitle;
    operationOptions.SyntaxVersion = 1;
    auto operation = factory->Run(sql, operationOptions);
    return operation;
}

void RunImportShopTable() {
    TString SQL = R"(
        use hahn;

        --host2vec
        $host2vec = (
            SELECT Host, 'host2vec' as source
            FROM `//home/webmaster/prod/turbo/shops_teasers_domains_tmp`
        );

        --выбираю самую свежую табличку из папки, которую дал мне маркет
        $names = (
            SELECT MAX(name) as stop,
            FROM (
                SELECT TableName(Path, "yt") as name
                FROM FOLDER(`home/logfeller/logs/market-offersrobot-sessions-stratocaster/1d`)
            )
        );

        $make_market_path="home/logfeller/logs/market-offersrobot-sessions-stratocaster/1d/"||$names;

        --приджойниваю к хосту способ, которым он доставляет данные в маркет
        $feed_type = (
            SELECT shop_id, Yson::ConvertToString(data.feedparser.feed_type)  AS feed_type
            FROM $make_market_path
            WHERE Yson::ConvertToString(data.feedparser.feed_type) != '""'
        );

        --приджойниваю к айди магазина его домен и выбираю только тех, кто посылают YML
        $market=(
            SELECT domain as Host, 'market' as source
            FROM (
                SELECT a.shop_id, a.domain_clean as domain, String::RemoveAll(f.feed_type,'"') as type
                FROM hahn.`//home/market/production/mstat/dictionaries/analyst_shops_dict/latest` as a
                LEFT JOIN $feed_type as f on a.shop_id=f.shop_id
                WHERE COALESCE(noffers, 0) > 0
            )
        );

        --радар
        $radars=(
            SELECT MAX(name) as stop,
            FROM (
                SELECT TableName(Path, "yt") as name
                FROM FOLDER(`//home/radar_top_sites/production/domain_markup/marked_domains`)
            )
        );

        $path_for_radar="//home/radar_top_sites/production/domain_markup/marked_domains/"||CAST($radars as string);

        --данные из радара, тут владельцы
        $from_radar=(
            SELECT domain as Host, 'radar' as source
            FROM $path_for_radar
            WHERE type=='ecommerce'
        );

        $domains=(
            SELECT Url::GetOwner(Host) as Host, source
            FROM (
                SELECT Host, source
                FROM $host2vec
                UNION ALL
                SELECT Host, source
                FROM $market
                UNION ALL
                SELECT Host, source
                FROM $from_radar
            )
        );

        $marketOwners = (
            SELECT Url::CutWWW(Url::GetOwner(Url::NormalizeWithDefaultHttpScheme(Host))) AS MascotOwner
            FROM $domains
            ORDER BY MascotOwner desc
        );

        INSERT INTO `${PREP_MARKET_TABLE}` WITH TRUNCATE
        SELECT DISTINCT MascotOwner FROM $marketOwners
        WHERE MascotOwner is not null
        ORDER BY MascotOwner;
    )";

    SubstGlobal(SQL, "${PREP_MARKET_TABLE}", TConfig::CInstance().TABLE_SERVICES_PREP_SHOP_HOSTS);
    RunYQL(SQL, "Import market hosts (YQL)");
}

int AboutShopHosts(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr clientFrom = NYT::CreateClient(cfg.MR_SERVER_HOST_SHOP_HOSTS);
    NYT::IClientPtr clientTo = NYT::CreateClient(cfg.MR_SERVER_HOST);

    NYTUtils::CreatePath(clientFrom, cfg.TABLE_SERVICES_PREP_ROOT);
    NYTUtils::CreatePath(clientTo, cfg.TABLE_SERVICES_PREP_ROOT);

    TString tableTimestamp;
    try {
        tableTimestamp = GetYtAttr(clientTo, cfg.TABLE_SERVICES_PREP_SHOP_HOSTS, cfg.ATTR_UPDATE_SOURCE).AsString();
    } catch (yexception &) {}

    TString curDay = Now().FormatLocalTime("%Y-%m-%d");
    if (curDay.equal(tableTimestamp)){
        LOG_INFO("achievements, ShopHosts, Shop hosts db already updated!");
        return 0;
    }

    LOG_INFO("achievements, ShopHosts, Start import market table");
    NYT::ITransactionPtr tx = clientFrom->StartTransaction();
    RunImportShopTable();
    SetYtAttr(tx, cfg.TABLE_SERVICES_PREP_SHOP_HOSTS, cfg.ATTR_UPDATE_SOURCE, curDay);
    TSortCmd<NProto::TPrepShop>
            (tx, TTable<NProto::TPrepShop>(tx, cfg.TABLE_SERVICES_PREP_SHOP_HOSTS))
            .By({"MascotOwner"})
            .OperationWeight(cfg.OPERATION_WEIGHT)
            .Do();
    LOG_INFO("achievements, ShopHosts, Import on hahn done, start transfer table to arnold");

    tx->Commit();

    TTransferManager tManager(TConfigBase::GetYTToken());
    tManager.PostTaskAndWait(cfg.MR_SERVER_HOST_SHOP_HOSTS, cfg.TABLE_SERVICES_PREP_SHOP_HOSTS, cfg.MR_SERVER_HOST, cfg.TABLE_SERVICES_PREP_SHOP_HOSTS);

    LOG_INFO("achievements, ShopHosts, task done");
    return 0;
}
} //namespace NWebmaster
