#include <util/draft/date.h>
#include <util/generic/set.h>
#include <util/thread/pool.h>

#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/table.h>
#include <yql/library/embedded/yql_embedded.h>
#include <kernel/urlnorm/normalize.h>

#undef LOG_DEBUG
#undef LOG_INFO
#undef LOG_ERROR

#include <wmconsole/version3/processors/siteservices/protos/sources.pb.h>
#include <wmconsole/version3/processors/siteservices/protos/services.pb.h>
#include <wmconsole/version3/processors/siteservices/conf/config.h>
#include <wmconsole/version3/wmcutil/yt/transfer_manager.h>

#include "import_util.h"
#include "task_about_snippet_pic_hosts.h"

namespace NWebmaster {
using namespace NJupiter;


int AboutSnippetPictureHost(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr client = NYT::CreateClient(cfg.MR_SERVER_HOST_SNIPPET_PIC);

    NYTUtils::CreatePath(client, cfg.TABLE_SERVICES_PREP_ROOT);

    TString tableTimestamp;
    TString maxSourceTimestamp = "-1";
    try {
        tableTimestamp = GetYtAttr(client, cfg.TABLE_SERVICES_PREP_SNIPPET_PIC, cfg.ATTR_UPDATE_SOURCE).AsString();
        maxSourceTimestamp = GetYtAttr(client, cfg.TABLE_SOURCE_SNIPPET_PIC, cfg.ATTR_CREATE_TIME).AsString();
    } catch (yexception &) {
    }

    if (tableTimestamp.equal(maxSourceTimestamp)){
        LOG_INFO("achievements, Snippet pictures, Db already updated!");
        return 0;
    }

    LOG_INFO("achievements,  Snippet pictures, Start import table");
    TString tableTmp = cfg.TABLE_SERVICES_PREP_SNIPPET_PIC + "-tmp";
    NYT::ITransactionPtr tx = client->StartTransaction();
    auto reader = tx->CreateTableReader<NProto::TScrSnippetPic>(cfg.TABLE_SOURCE_SNIPPET_PIC);
    auto writer = tx->CreateTableWriter<NProto::TPrepSnippetPic>(tableTmp);
    NProto::TPrepSnippetPic prepSnippetPic;

    for (; reader->IsValid(); reader->Next()) {
        const auto &row = reader->GetRow();
        prepSnippetPic.SetMascotOwner(GetOwner(row.GetUrl()));
        writer->AddRow(prepSnippetPic);
    }

    LOG_INFO("achievements,  Snippet pictures, Done copy table");

    writer->Finish();

    TSortCmd<NProto::TPrepSnippetPic>(tx, TTable<NProto::TPrepSnippetPic>(tx, tableTmp))
            .By({"MascotOwner"})
            .OperationWeight(cfg.OPERATION_WEIGHT)
            .Do();

    LOG_INFO("achievements,  Snippet pictures, Done sort table");

    auto readerTmp = tx->CreateTableReader<NProto::TPrepSnippetPic>(tableTmp);
    writer = tx->CreateTableWriter<NProto::TPrepSnippetPic>(cfg.TABLE_SERVICES_PREP_SNIPPET_PIC);
    TString prevOwner = "";
    for (; readerTmp->IsValid(); readerTmp->Next()) {
        const auto &row = readerTmp->GetRow();
        if (!prevOwner.equal(row.GetMascotOwner())) {
            TString normalized;
            if (NUrlNorm::NormalizeUrl(row.GetMascotOwner(), normalized)){
                prepSnippetPic.SetMascotOwner(GetOwner(normalized));
                writer->AddRow(prepSnippetPic);
            }
        }
        prevOwner = row.GetMascotOwner();
    }
    writer->Finish();

    TSortCmd<NProto::TPrepSnippetPic>(tx, TTable<NProto::TPrepSnippetPic>(tx, cfg.TABLE_SERVICES_PREP_SNIPPET_PIC))
            .By({"MascotOwner"})
            .OperationWeight(cfg.OPERATION_WEIGHT)
            .Do();


    SetYtAttr(tx, cfg.TABLE_SERVICES_PREP_SNIPPET_PIC, cfg.ATTR_UPDATE_SOURCE, maxSourceTimestamp);

    tx->Commit();

    //TTransferManager tManager(TConfigBase::GetYTToken());
    //tManager.PostTaskAndWait(cfg.MR_SERVER_HOST_MARKET, cfg.TABLE_SERVICES_PREP_SNIPPET_PIC, cfg.MR_SERVER_HOST, cfg.TABLE_SERVICES_PREP_SNIPPET_PIC);

    LOG_INFO("achievements,  Snippet pictures, Import done");
    return 0;}
} //namespace NWebmaster

