#include <util/draft/date.h>
#include <util/generic/set.h>
#include <util/thread/pool.h>

#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/table.h>
#include <yql/library/embedded/yql_embedded.h>

#undef LOG_DEBUG
#undef LOG_INFO
#undef LOG_ERROR

#include <wmconsole/version3/processors/siteservices/protos/sources.pb.h>
#include <wmconsole/version3/processors/siteservices/protos/services.pb.h>
#include <wmconsole/version3/processors/siteservices/conf/config.h>
#include <wmconsole/version3/wmcutil/yt/transfer_manager.h>

#include "import_util.h"
#include "task_about_uslugi_hosts.h"

namespace NWebmaster {
using namespace NJupiter;

THolder<NYql::NEmbedded::IOperation> RunUslugiYQL(const TString &sql, const TString &operationTitle) {
    NYql::NEmbedded::TOperationFactoryOptions factoryOptions;
    auto factory = NYql::NEmbedded::MakeOperationFactory(factoryOptions);
    NYql::NEmbedded::TOperationOptions operationOptions;
    operationOptions.Title = operationTitle;
    operationOptions.SyntaxVersion = 1;
    auto operation = factory->Run(sql, operationOptions);
    return operation;
}


void RunImportUslugiTable() {
    TString SQL = R"(
        use hahn;

        INSERT INTO `${PREP_USLUGI_TABLE}` (
        select
            Url::CutWWW(Url::GetOwner(Url::Normalize(Yson::ConvertToString(Yson::YPath(Yson::Parse(personal_info), "/site"))))) as MascotOwner,
            id as Id
        from
            `//home/ydo/backups/prod/current/workers`
        where
            status == 3
            and Yson::ConvertToString(Yson::YPath(Yson::Parse(personal_info), "/site")) is not null
            and not (Url::GetOwner(Url::Normalize(Yson::ConvertToString(Yson::YPath(Yson::Parse(personal_info), "/site")))) in
                aslist(
                    "instagram.com",
                    "vk.com",
                    "yandex.ru",
                    "twitter.com",
                    "facebook.com"
                )
            )
        order by MascotOwner
        )
    )";

    SubstGlobal(SQL, "${PREP_USLUGI_TABLE}", TConfig::CInstance().TABLE_SERVICES_PREP_USLUGI);
    RunUslugiYQL(SQL, "Import uslugi hosts (YQL)");
}

int AboutUslugiHosts(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr clientFrom = NYT::CreateClient(cfg.MR_SERVER_HOST_USLUGI);
    NYT::IClientPtr clientTo = NYT::CreateClient(cfg.MR_SERVER_HOST);

    NYTUtils::CreatePath(clientFrom, cfg.TABLE_SERVICES_PREP_ROOT);
    NYTUtils::CreatePath(clientTo, cfg.TABLE_SERVICES_PREP_ROOT);

    TString tableTimestamp;
    try {
        tableTimestamp = GetYtAttr(clientTo, cfg.TABLE_SERVICES_PREP_USLUGI, cfg.ATTR_UPDATE_SOURCE).AsString();
    } catch (yexception &) {}

    TString curDay = Now().FormatLocalTime("%Y-%m-%d");
    if (curDay.equal(tableTimestamp)){
        LOG_INFO("achievements, UslugiHosts, Uslugi hosts db already updated!");
        return 0;
    }

    LOG_INFO("achievements, UslugiHosts, Start import Uslugi table");
    NYT::ITransactionPtr tx = clientFrom->StartTransaction();
    RunImportUslugiTable();
    SetYtAttr(tx, cfg.TABLE_SERVICES_PREP_USLUGI, cfg.ATTR_UPDATE_SOURCE, curDay);
    TSortCmd<NProto::TPrepUslugi>
            (tx, TTable<NProto::TPrepUslugi>(tx, cfg.TABLE_SERVICES_PREP_USLUGI))
            .By({"MascotOwner"})
            .OperationWeight(cfg.OPERATION_WEIGHT)
            .Do();
    LOG_INFO("achievements, UslugiHosts, Import on hahn done, start transfer table to arnold");

    tx->Commit();

    TTransferManager tManager(TConfigBase::GetYTToken());
    tManager.PostTaskAndWait(cfg.MR_SERVER_HOST_USLUGI, cfg.TABLE_SERVICES_PREP_USLUGI, cfg.MR_SERVER_HOST, cfg.TABLE_SERVICES_PREP_USLUGI);

    LOG_INFO("achievements, UslugiHosts, task done");
    return 0;
}
} //namespace NWebmaster
