#include <util/draft/date.h>
#include <util/generic/set.h>
#include <util/thread/pool.h>

#include <library/cpp/string_utils/url/url.h>
#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/table.h>
#include <yql/library/embedded/yql_embedded.h>
#include <kernel/urlnorm/normalize.h>

#undef LOG_DEBUG
#undef LOG_INFO
#undef LOG_ERROR

#include <wmconsole/version3/processors/siteservices/protos/sources.pb.h>
#include <wmconsole/version3/processors/siteservices/protos/services.pb.h>
#include <wmconsole/version3/processors/siteservices/conf/config.h>
#include <wmconsole/version3/wmcutil/yt/transfer_manager.h>
#include <wmconsole/version3/wmcutil/config_base.h>

#include <ctime>

#include "import_util.h"
#include "task_about_vertical_share.h"

namespace NWebmaster {
using namespace NJupiter;

int AboutVerticalShare(int, const char **) {
    const auto &cfg = TConfig::CInstance();
    NYT::IClientPtr client = NYT::CreateClient(cfg.MR_SERVER_HOST_VERTICAL_SHARE);

    NYTUtils::CreatePath(client, cfg.TABLE_SERVICES_PREP_ROOT);

    TString tableTimestamp;
    TString maxSourceTimestamp = "-1";
    try {
        tableTimestamp = GetYtAttr(client, cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE, cfg.ATTR_UPDATE_SOURCE).AsString();
        maxSourceTimestamp = GetYtAttr(client, cfg.TABLE_SOURCE_VERTICAL_SHARE, cfg.ATTR_CREATE_TIME).AsString();
    } catch (yexception &) {
    }

    if (tableTimestamp.equal(maxSourceTimestamp)){
        LOG_INFO("achievements, VerticalShare, Db already updated!");
        return 0;
    }

    LOG_INFO("achievements, VerticalShare, Start import table");
    NYT::ITransactionPtr tx = client->StartTransaction();
    auto reader = tx->CreateTableReader<NProto::TSrcVerticalShare>(cfg.TABLE_SOURCE_VERTICAL_SHARE);
    auto writer = tx->CreateTableWriter<NProto::TPrepVerticalShare>(cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE);
    NProto::TPrepVerticalShare prepVerticalShare;

    for (; reader->IsValid(); reader->Next()) {
        const auto &row = reader->GetRow();
        prepVerticalShare.SetMascotOwner(GetOwner(row.GetDomain()));
        prepVerticalShare.SetRating(round(row.GetRating()*10)/10);
        prepVerticalShare.SetIsValidated(row.GetIsValidated());
        writer->AddRow(prepVerticalShare);
    }

    writer->Finish();

    LOG_INFO("achievements, VerticalShare, Done copy table");

    TSortCmd<NProto::TPrepVerticalShare>(tx, TTable<NProto::TPrepVerticalShare>(tx, cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE))
            .By({"MascotOwner"})
            .OperationWeight(cfg.OPERATION_WEIGHT)
            .Do();

    LOG_INFO("achievements, VerticalShare, Done sort table");

    SetYtAttr(tx, cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE, cfg.ATTR_UPDATE_SOURCE, maxSourceTimestamp);

    tx->Commit();

    TTransferManager tManager(TConfigBase::GetYTToken());
    tManager.PostTaskAndWait(cfg.MR_SERVER_HOST_VERTICAL_SHARE, cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE, cfg.MR_SERVER_HOST, cfg.TABLE_SERVICES_PREP_VERTICAL_SHARE);

    LOG_INFO("achievements, VerticalShare, Import done");
    return 0;
}
} //namespace NWebmaster
