USE arnold;
PRAGMA yt.Pool="robot-webmaster";
PRAGMA Warning("disable", "1030");
PRAGMA Warning("disable", "1107");

$format = DateTime::Format("%Y%m%d");
$parse  = DateTime::Parse("%Y%m%d");

$features_root = "//home/webmaster/prod/iks/source/mascot_weekly";

$src_features = (
    select aggregate_list(Period) as Source
    from (
        select TableName(Path, "yt") as Period
        from folder($features_root)
        where Type == "table"
        order by Period desc
        limit 2
    )
);

$period_current = select  Source[0] from $src_features;
$period_previous = select Source[1] from $src_features;

$prod_iks_table         = "//home/webmaster/prod/iks/IKS";
$prod_features_table    = $features_root || "/" || $period_previous;
$stage_iks_table        = "//home/webmaster/prod/iks/stage/IKS";
$stage_features_table   = $features_root || "/" || $period_current;
$acceptance_diff        = "//home/webmaster/prod/iks/stage/acceptance-diff";
$acceptance_stat        = "//home/webmaster/prod/iks/stage/acceptance-stat";

$LongVisitsShare = (
    $More120SecVisitsNotSearchShare,
    $More120SecVisitsSearchShare,
    $More120SecVisitsSearchShareUserSessions,
    $More120SecVisitsShare,
    $More160SecVisitsShare,
    $More30SecVisitsShare,
    $More60SecVisitsNotSearchShare,
    $More60SecVisitsSearchShare,
    $More60SecVisitsSearchShareUserSessions,
    $More60SecVisitsShare,
    $More60SecVisitsShareYaBro,
    $More90SecVisitsShare
) -> {
    RETURN CAST($More120SecVisitsNotSearchShare * 120
        + $More120SecVisitsSearchShare * 120
        + $More120SecVisitsSearchShareUserSessions * 120
        + $More120SecVisitsShare * 120
        + $More160SecVisitsShare * 160
        + $More30SecVisitsShare * 30
        + $More60SecVisitsNotSearchShare * 60
        + $More60SecVisitsSearchShare * 60
        + $More60SecVisitsSearchShareUserSessions * 60
        + $More60SecVisitsShare * 60
        + $More60SecVisitsShareYaBro * 60
        + $More90SecVisitsShare * 90
        AS DOUBLE
    ) / 160.0 / 12.0;
};

$DiffString = ($prev, $curr) -> {
    RETURN COALESCE(CAST(Math::Round($prev, -1) AS String), "N") 
        || " > "
        || COALESCE(CAST(Math::Round($curr, -1) AS String), "N");
};

$Delta = ($prev, $curr) -> {
    RETURN COALESCE($curr, 0) - COALESCE($prev, 0);
};

$prev = (
    SELECT
        iks.Host AS Host,
        CAST(iks.IKS AS Int64) AS IKS,
        iks.IKSRaw AS IKSRaw,
        iks.IKSNotPenalized - iks.IKSNotPenalized * COALESCE(iks.PenaltyMultiplier, 1) AS Penalty,
        features.Visitors AS Visitors,
        features.cy_flt_100 AS cy_flt_100,
        features.uid_GT_all_d + features.uid_GT_all_m AS GV1d,
        features.uniq_uid_GT_all_d + features.uniq_uid_GT_all_m AS GV28d,
        $LongVisitsShare(
            features.More120SecVisitsNotSearchShare,
            features.More120SecVisitsSearchShare,
            features.More120SecVisitsSearchShareUserSessions,
            features.More120SecVisitsShare,
            features.More160SecVisitsShare,
            features.More30SecVisitsShare,
            features.More60SecVisitsNotSearchShare,
            features.More60SecVisitsSearchShare,
            features.More60SecVisitsSearchShareUserSessions,
            features.More60SecVisitsShare,
            features.More60SecVisitsShareYaBro,
            features.More90SecVisitsShare,
        ) AS LongVisitsShare,
    FROM $prod_iks_table AS iks
    INNER JOIN $prod_features_table AS features
        ON iks.Host == features.Owner
);

$curr = (
    SELECT
        iks.Host AS Host,
        CAST(iks.IKS AS Int64) AS IKS,
        iks.IKSRaw AS IKSRaw,
        iks.IKSNotPenalized - iks.IKSNotPenalized * COALESCE(iks.PenaltyMultiplier, 1) AS Penalty,
        features.Visitors AS Visitors,
        features.cy_flt_100 AS cy_flt_100,
        features.uid_GT_all_d + features.uid_GT_all_m AS GV1d,
        features.uniq_uid_GT_all_d + features.uniq_uid_GT_all_m AS GV28d,
        $LongVisitsShare(
            features.More120SecVisitsNotSearchShare,
            features.More120SecVisitsSearchShare,
            features.More120SecVisitsSearchShareUserSessions,
            features.More120SecVisitsShare,
            features.More160SecVisitsShare,
            features.More30SecVisitsShare,
            features.More60SecVisitsNotSearchShare,
            features.More60SecVisitsSearchShare,
            features.More60SecVisitsSearchShareUserSessions,
            features.More60SecVisitsShare,
            features.More60SecVisitsShareYaBro,
            features.More90SecVisitsShare,
        ) AS LongVisitsShare
    FROM $stage_iks_table AS iks
    INNER JOIN $stage_features_table AS features
        ON iks.Host == features.Owner
);

$diff = (
    SELECT
        COALESCE(prev.Host, curr.Host) AS Host,
        prev.IKS AS PrevIKS,
        curr.IKS AS CurrIKS,
        prev.IKSRaw AS PrevIKSRaw,
        curr.IKSRaw AS CurrIKSRaw,
        prev.Penalty AS PrevPenalty,
        curr.Penalty AS CurrPenalty,
        prev.Visitors AS PrevVisitors,
        curr.Visitors AS CurrVisitors,
        prev.LongVisitsShare AS PrevLongVisitsShare,
        curr.LongVisitsShare AS CurrLongVisitsShare,
        prev.cy_flt_100 AS Prev_cy_flt_100,
        curr.cy_flt_100 AS Curr_cy_flt_100,
        prev.GV1d AS PrevGV1d,
        curr.GV1d AS CurrGV1d,
        prev.GV28d AS PrevGV28d,
        curr.GV28d AS CurrGV28d,
        $Delta(prev.IKS, curr.IKS) AS DeltaX,
        ABS($Delta(prev.IKS, curr.IKS)) AS AbsoluteDeltaX,
        Math::Round(
            CAST($Delta(prev.IKS, curr.IKS) AS Double)
                / CAST(COALESCE(curr.IKS, prev.IKS) AS Double),
            -2
        ) * 100 AS `Delta%`,
    FROM $prev AS prev
    FULL JOIN $curr AS curr
        ON prev.Host = curr.Host
);

INSERT INTO $acceptance_diff WITH TRUNCATE
SELECT
    Host,
    DeltaX,
    `Delta%`,
    $DiffString(PrevIKS, CurrIKS) AS IKS,
    $DiffString(PrevIKSRaw, CurrIKSRaw) AS IKSRaw,
    $DiffString(PrevPenalty, CurrPenalty) AS Penalty,
    $DiffString(PrevVisitors, CurrVisitors) AS Visitors,
    $DiffString(PrevLongVisitsShare, CurrLongVisitsShare) AS LongVisitsShare,
    $DiffString(Prev_cy_flt_100, Curr_cy_flt_100) AS cy_flt_100,
    $DiffString(PrevGV1d, CurrGV1d) AS GV1d,
    $DiffString(PrevGV28d, CurrGV28d) AS GV28d,
    AbsoluteDeltaX,
FROM $diff
ORDER BY AbsoluteDeltaX DESC
INTO RESULT Diff;

$stat = (
    SELECT
        SUM(PrevIKS) AS PrevSum,
        SUM(CurrIKS) AS NewSum,
        AVG(PrevIKS) AS PrevMean,
        AVG(CurrIKS) AS NewMean,
        MEDIAN(PrevIKS) AS PrevMedian,
        MEDIAN(CurrIKS) AS NewMedian,
        COUNT_IF(PrevIKS IS NULL) AS NewHosts,
        COUNT_IF(CurrIKS IS NULL) AS GoneHosts,
    FROM $diff
);

INSERT INTO $acceptance_stat WITH TRUNCATE
SELECT "Кандидат в ИКС"
    || "\n"
    || "\nhttps://yt.yandex-team.ru/arnold/navigation?path=" || $acceptance_diff
    || "\n"
    || "\nДали ИКС " || CAST(NewHosts as String) || " новым"
    || "\nОтобрали у " || CAST(GoneHosts as String)
    || "\n"
    || "\nРаньше"
    || "\nСумма " || CAST(PrevSum as String)
    || "\nСреднее " || CAST(PrevMean as String)
    || "\nМедиана " || CAST(PrevMedian as String)
    || "\n"
    || "\nСейчас"
    || "\nСумма " || CAST(NewSum as String)
    || "\nСреднее " || CAST(NewMean as String)
    || "\nМедиана " || CAST(NewMedian as String)
        as Report
FROM $stat;
