#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"

namespace NWebmaster {
namespace NIks {

TConfig::TConfig() {
    MR_SERVER_HOST                      = "arnold.yt.yandex.net";
    MR_SERVER_HOST_RADAR                = "hahn.yt.yandex.net";

    FILE_CY_HASH_LOCAL                  = "cy.hash";

    TABLE_ROOT_IKS                      = "//home/webmaster/prod/iks";
    TABLE_ROOT_IKS_PREV                 = NYTUtils::JoinPath(TABLE_ROOT_IKS, "prev");
    TABLE_ROOT_IKS_STAGE                = NYTUtils::JoinPath(TABLE_ROOT_IKS, "stage");
    TABLE_ROOT_MASCOT_RANKS_HISTORY     = NYTUtils::JoinPath(TABLE_ROOT_IKS, "source", "mascot_weekly");

    TABLE_SOURCE_QUERIES_ROOT           = "//home/webmaster/prod/searchqueries/converted_v4";

    TABLE_SOURCE_ACHIEVEMENTS_ROOT      = "//home/antispam/achievements";
    TABLE_SOURCE_FROZEN_CY_DATA         = NYTUtils::JoinPath(TABLE_ROOT_IKS, "source", "cy");
    //TABLE_SOURCE_IKS_PENALTY            = "//home/webmaster/prod/iks/antispam_attmr_history";
    //TABLE_SOURCE_IKS_PENALTY            = "//home/antispam/attmr/history";
    TABLE_SOURCE_IKS_PENALTY            = "//home/antispam/export/webmaster/fastatt_history";
    TABLE_SOURCE_MASCOT_RANKS           = "//home/antispam/export/x_rank";
    //TABLE_SOURCE_MASCOT_RANKS           = "//home/antispam/mascot/export/x_rank";
    TABLE_SOURCE_TIC_DATA               = NYTUtils::JoinPath(TABLE_ROOT_IKS, "tic-data");
    TABLE_SOURCE_BANDETECTOR            = "//home/lemur-data/ban-detector/alive_owners";
    TABLE_SOURCE_RADAR_MAU_ROOT         = "//home/radar_top_sites/production/predicted_top";

    TABLE_IKS_EXPORT                    = "//home/webmaster/prod/export/IKS";
    TABLE_IKS_PENALTY                   = NYTUtils::JoinPath(TABLE_ROOT_IKS, "penalty_v2");
    TABLE_IKS_DATA_ACCEPTED             = NYTUtils::JoinPath(TABLE_ROOT_IKS, "IKS");
    TABLE_IKS_DATA_STAGE_FULL           = NYTUtils::JoinPath(TABLE_ROOT_IKS_STAGE, "full");
    TABLE_IKS_DATA_STAGE                = NYTUtils::JoinPath(TABLE_ROOT_IKS_STAGE, "IKS");
    TABLE_IKS_MIRRORS_STAGE             = NYTUtils::JoinPath(TABLE_ROOT_IKS_STAGE, "mirrors");

    FILE_CY_HASH_YT_ACCEPTED            = NYTUtils::JoinPath(TABLE_ROOT_IKS, FILE_CY_HASH_LOCAL);
    FILE_CY_HASH_YT_STAGE               = NYTUtils::JoinPath(TABLE_ROOT_IKS_STAGE, FILE_CY_HASH_LOCAL);
    FILE_CY_HASH_YT_PREV                = NYTUtils::JoinPath(TABLE_ROOT_IKS, "prev_cy_hash");

    TABLE_IKS_CONTENT                   = NYTUtils::JoinPath(TABLE_ROOT_IKS, "content");
    TABLE_IKS_OWNERS_CY                 = NYTUtils::JoinPath(TABLE_ROOT_IKS, "owners_cy");

    TABLE_IKS_VITALITY_ROOT             = NYTUtils::JoinPath(TABLE_ROOT_IKS_STAGE, "vitality");
    TABLE_IKS_VITALITY_ROBOT            = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "robot");
    TABLE_IKS_VITALITY_IKS              = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "IKS");
    TABLE_IKS_VITALITY_HOSTDAT          = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "hostdat");
    TABLE_IKS_VITALITY_SERP             = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "serp");
    TABLE_IKS_VITALITY_TO_BANDETECTOR   = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "need-ban-detect");
    TABLE_IKS_VITALITY_FROM_BANDETECTOR = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "bandetector");
    TABLE_IKS_VITALITY_STATE            = NYTUtils::JoinPath(TABLE_IKS_VITALITY_ROOT, "vitality");
}

} //namespace NIks {
} //namespace NWebmaster
