#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

namespace NWebmaster {
namespace NIks {

struct TConfig {
    TConfig();

    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

public:
    const float OPERATION_WEIGHT = 100.0f;
    TString FILE_CY_HASH_LOCAL;
    TString FILE_CY_HASH_YT_ACCEPTED;
    TString FILE_CY_HASH_YT_PREV;
    TString FILE_CY_HASH_YT_STAGE;
    TString TABLE_ROOT_IKS;
    TString TABLE_ROOT_IKS_PREV;
    TString TABLE_ROOT_IKS_STAGE;
    TString TABLE_ROOT_MASCOT_RANKS_HISTORY;
    TString TABLE_SOURCE_ACHIEVEMENTS_ROOT;
    TString TABLE_SOURCE_FROZEN_CY_DATA;
    TString TABLE_SOURCE_MASCOT_RANKS;
    TString TABLE_SOURCE_IKS_PENALTY;
    TString TABLE_SOURCE_TIC_DATA;
    TString TABLE_SOURCE_QUERIES_ROOT;
    TString TABLE_SOURCE_BANDETECTOR;
    TString TABLE_SOURCE_RADAR_MAU_ROOT;
    TString TABLE_IKS_EXPORT;
    TString TABLE_IKS_DATA_ACCEPTED;
    TString TABLE_IKS_DATA_STAGE;
    TString TABLE_IKS_DATA_STAGE_FULL;
    TString TABLE_IKS_OWNERS_CY;
    TString TABLE_IKS_MIRRORS_STAGE;
    TString TABLE_IKS_PENALTY;

    TString TABLE_IKS_VITALITY_ROOT;
    TString TABLE_IKS_VITALITY_ROBOT;
    TString TABLE_IKS_VITALITY_IKS;
    TString TABLE_IKS_VITALITY_HOSTDAT;
    TString TABLE_IKS_VITALITY_SERP;
    TString TABLE_IKS_VITALITY_STATE;
    TString TABLE_IKS_VITALITY_TO_BANDETECTOR;
    TString TABLE_IKS_VITALITY_FROM_BANDETECTOR;

    TString MR_SERVER_HOST;
    TString MR_SERVER_HOST_RADAR;

    TString TABLE_IKS_CONTENT;
};

} //namespace NIks
} //namespace NWebmaster
