#pragma once

#include <yweb/antispam/mascot/dump/protos/dumps.pb.h>
#include <yweb/antispam/mascot/dump/protos/exports.pb.h>

namespace NWebmaster {
namespace NIks {

struct TCounter {
    void Add(float value) {
        Value += value;
        Count++;
    }

    float Get() const {
        if (Count > 0) {
            return Value / static_cast<float>(Count);
        }
        return 0.0f;
    }

    void Set(float value) {
        Value = value;
        Count = 1;
    }

    void SetLatest(float value, time_t timestamp) {
        if (timestamp > Timestamp) {
            Value = value;
            Count = 1;
            Timestamp = timestamp;
        }
    }

public:
    size_t Count    = 0;
    float Value     = 0.0f;
    time_t Timestamp = 0;
};

struct TCounters {
    void Add(time_t timestamp, const NMascot::TXDump &features) {
        AvgMoreNSecVisits.Add(
            (
                + features.GetMore120SecVisitsNotSearchShare()          * 120.0f / 160.0f
                + features.GetMore120SecVisitsSearchShare()             * 120.0f / 160.0f
                + features.GetMore120SecVisitsSearchShareUserSessions() * 120.0f / 160.0f
                + features.GetMore120SecVisitsShare()                   * 120.0f / 160.0f
                + features.GetMore160SecVisitsShare()                   * 160.0f / 160.0f
                + features.GetMore30SecVisitsShare()                    *  30.0f / 160.0f
                + features.GetMore60SecVisitsNotSearchShare()           *  60.0f / 160.0f
                + features.GetMore60SecVisitsSearchShare()              *  60.0f / 160.0f
                + features.GetMore60SecVisitsSearchShareUserSessions()  *  60.0f / 160.0f
                + features.GetMore60SecVisitsShare()                    *  60.0f / 160.0f
                + features.GetMore60SecVisitsShareYaBro()               *  60.0f / 160.0f
                + features.GetMore90SecVisitsShare()                    *  90.0f / 160.0f
            ) / 12.0f
        );

        GT.Add(
            + features.GetGreenTrafficDesktopAllCount()
            + features.GetGreenTrafficMobileAllCount()
        );

        if (features.Hasuniq_uid_GT_all_d()) {
            const float GV1d    = features.Getuid_GT_all_d();
            const float GV1m    = features.Getuid_GT_all_m();

            const float GV28d   = features.Getuniq_uid_GT_all_d();
            const float GV28m   = features.Getuniq_uid_GT_all_m();

            const float X = GV1d + GV1m;
            const float Y = GV28d + GV28m;

            const float Z = Y > 0.0f ? X / Y : 0.0f;
            const float L = Z > 1.0f ? std::log10(Z) : 0.0f;

            const float B = Y > 0.0f ? std::pow(X * Y, 1.5f) / (Y * Y + 10.0f) : 0.0f;

            //GV1.Add(B);
            //GV2.Add(B * (0.7f + std::pow(std::max(0.0f, Z - 1.0f) / 42.0f, 1.0f / 3.0f)));
            GV3.Add(B * (0.7f + L / (2.0f * L + 0.3f)));
        }

        Visitors.Add(features.GetVisitors());

        if (timestamp > 1543525200 /* 20181130 */ && timestamp < 1626037200 /* 20210712 */) {
            CY100.Add(features.Getcy_flt_100());
        }

        UGC_org_rating_count.SetLatest(features.GetUGC_org_rating_count(), timestamp);
        UGC_org_rating_value.SetLatest(features.GetUGC_org_rating_value(), timestamp);

        Count++;
    }

    void SetCY(size_t cy_flt_100) {
        CY100.Set(cy_flt_100);
    }

    size_t GetCount() const {
        return Count;
    }

public:
    TCounter AvgMoreNSecVisits;
    TCounter GT;
    TCounter GV1;
    TCounter GV2;
    TCounter GV3;
    TCounter Visitors;
    TCounter CY100;
    TCounter UGC_org_rating_count;
    TCounter UGC_org_rating_value;
    size_t Count = 0;
};

} //namespace NIks
} //namespace NWebmaster
