use arnold;
pragma yt.Pool="robot-webmaster";

$avg_sl = ($features) -> {
    return (
        + $features.More120SecVisitsNotSearchShare          * 120.0f / 160.0f
        + $features.More120SecVisitsSearchShare             * 120.0f / 160.0f
        + $features.More120SecVisitsSearchShareUserSessions * 120.0f / 160.0f
        + $features.More120SecVisitsShare                   * 120.0f / 160.0f
        + $features.More160SecVisitsShare                   * 160.0f / 160.0f
        + $features.More30SecVisitsShare                    * 30.0f / 160.0f
        + $features.More60SecVisitsNotSearchShare           * 60.0f / 160.0f
        + $features.More60SecVisitsSearchShare              * 60.0f / 160.0f
        + $features.More60SecVisitsSearchShareUserSessions  * 60.0f / 160.0f
        + $features.More60SecVisitsShare                    * 60.0f / 160.0f
        + $features.More60SecVisitsShareYaBro               * 60.0f / 160.0f
        + $features.More90SecVisitsShare                    * 90.0f / 160.0f
    ) / 12.0f
};

$gv = ($features) -> {
    $GV1d    = cast($features.uid_GT_all_d as float);
    $GV1m    = cast($features.uid_GT_all_m as float);
    $GV28d   = cast($features.uniq_uid_GT_all_d as float);
    $GV28m   = cast($features.uniq_uid_GT_all_m as float);

    $X = $GV1d + $GV1m;
    $Y = $GV28d + $GV28m;
    $Z = if ($Y > 0.0f, $X / $Y, 0.0f);
    $L = if ($Z > 1.0f, Math::Log10($Z), 0.0f);
    $B = if ($Y > 0.0f, Math::Pow($X * $Y, 1.5f) / ($Y * $Y + 10.0f), 0.0f);
    return $B * (0.7f + $L / (2.0f * $L + 0.3f))
};

insert into `//home/webmaster/prod/export/IKS.all.nomirrors`
    with truncate
select Key, IKSRaw from (
    select Key, 
          (1.0f + Math::Log($avg_sl(Features) * cast(Features.Visitors as float) + 1.0f)) 
        * (1.0f + Math::Log(cast(Features.cy_flt_100 as float) * 42.0f + 1.0f)) 
        * (1.0f + Math::Log($gv(Features) + 1.0f)) as IKSRaw
    from `//home/antispam/mascot/database`
) where IKSRaw is not null
order by Key
