use arnold;
PRAGMA yt.InferSchema = '1';

$table_name = (
    SELECT Max(TableName(Path, "yt")) as tName FROM FOLDER(`//home/webmaster/prod/export/archive/webmaster-verified-hosts`)
);

$verified_host_info = '//home/webmaster/prod/export/archive/webmaster-verified-hosts/' || $table_name;

$date_parser = DateTime::Parse('%Y-%m-%d'); 
$date_format = DateTime::Format('%Y-%m-%d');

$root = '//home/webmaster/prod/iks';
$root_path = 'home/webmaster/prod/iks';
$content = $root || '/content';
$content_path = $root_path || '/content';
$base_notification_dir = $root || '/notification';
$email_prefix = 'iks_update_notification_';
$rival_email_prefix = 'iks_rival_update_notification_';

$notification_table_date = (
    select AggregateList($date_format(DateTime::MakeDate($date_parser(SUBSTRING(Path,LEN($root_path) + LEN('/notification') +  LEN($email_prefix) + cast(1L as Uint32))))))
    from FOLDER($base_notification_dir)
    where Path like '%'||$email_prefix||'%'
);

$content_creation = (
    SELECT $date_format(DateTime::MakeDate(DateTime::ParseIso8601(Yson::LookupString(Attributes, 'modification_time'))))
    FROM FOLDER($root, "modification_time")
    WHERE Path == $content_path
);




$iks_update_notification = $base_notification_dir || '/' || $email_prefix || $content_creation;
$iks_rival_update_notification = $base_notification_dir || '/' || $rival_email_prefix || $content_creation;

DEFINE ACTION $make_new_iks_notification() AS
    insert into $iks_update_notification WITH TRUNCATE 
    select cast(wvh.user_id as Uint64) as user_id, RandomUuid(user_id) as row_uuid, wvh.host_id as host_id,iks.IKS as iks, iks.Host as host 
        from $content as iks
        INNER JOIN $verified_host_info  as wvh on wvh.host_url = iks.Host
    where iks.IKS != iks.PreviousIKS and Url::GetOwner(iks.Host) = iks.Owner
    Order by user_id, iks DESC;

    COMMIT;

    insert into $iks_rival_update_notification WITH TRUNCATE
    select user_id,AGGREGATE_LIST_DISTINCT(wvh.host_id ) as hosts from `//home/webmaster/prod/export/iks_rival` as ir
        inner join (select host from $iks_update_notification  group by host) as iun on Url::GetOwner(iun.host) = ir.rival 
        INNER JOIN $verified_host_info  as wvh on wvh.host_id = ir.host_id
        left join (select user_id from $iks_update_notification group by user_id) as uuv on cast(wvh.user_id as Uint64)  = uuv.user_id
    where uuv.user_id is null
    group by cast(wvh.user_id as Uint64) as user_id
    ORDER BY user_id

END DEFINE;

EVALUATE IF not ListHas($notification_table_date,$content_creation) DO $make_new_iks_notification();
