#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/version3/processors/tools/IKS/penalty.cpp>

using namespace NWebmaster;
using namespace NWebmaster::NIks;

Y_UNIT_TEST_SUITE(TWebmasterIKSPenaltyTest) {
    bool IsSanctionVisibleInWebmasterStub(const TString &sanction, TString &threatName) {
        threatName = "THREAT_" + sanction;
        return sanction == "b";
    }

    Y_UNIT_TEST(WebmasterIKSPenaltyTest1) {
        THistory historyMsg;
        TRepeatedStringHistoryEntry *entry = nullptr;

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(100);
        *entry->AddValue() = "";

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(200);
        *entry->AddValue() = "a";

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(250);
        *entry->AddValue() = "b";

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(300);
        *entry->AddValue() = "";

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(350);
        *entry->AddValue() = "a";

        entry = historyMsg.AddHistory();
        entry->SetTimestamp(400);
        *entry->AddValue() = "a";
        *entry->AddValue() = "b";

        //entry = historyMsg.AddHistory();
        //entry->SetTimestamp(500);
        // *entry->AddValue() = "";

        THashMap<TString, TMultiMap<time_t, bool>> events;
        ExtractHistory(historyMsg, events);

        time_t lastSanctionTimestamp = 0;
        TDeque<TSpan> spans, ranges;
        THashMap<TString, TDeque<TSpan>> spansBySanction;
        FinalizeSpans(events, spans, spansBySanction, 250, 1000, IsSanctionVisibleInWebmasterStub);
        ExtractRanges(spans, ranges, lastSanctionTimestamp);

        UNIT_ASSERT_EQUAL(
            TIKSPenaltyMapper::GetSanctionsDetailsStr(spansBySanction, IsSanctionVisibleInWebmasterStub),
            "a(THREAT_a)=0 350-1000 / b(THREAT_b)=1 250-300 400-1000"
        );

        size_t secondsUnderSanctions = 0;
        UNIT_ASSERT_EQUAL(TIKSPenaltyMapper::GetUsedRangesStr(ranges, secondsUnderSanctions), "250-300 400-1000");
        UNIT_ASSERT_EQUAL(secondsUnderSanctions, 650);
    }
}
