#include <util/memory/blob.h>

#include <library/cpp/archive/yarchive.h>
#include <library/cpp/string_utils/url/url.h>

#include <robot/library/yt/static/table.h>

#include <wmconsole/version3/processors/tools/IKS/protos/iks.pb.h>

#include "utils.h"

using namespace NJupiter;

namespace NWebmaster {
namespace NIks {

NYT::TRichYPath DebugPath(const TString &table) {
/*
    TDeque<TString> keys = {
        "http://169.tehnosila.ru",
        "http://32.tehnosila.ru",
        "http://46.tehnosila.ru",
        "http://51.tehnosila.ru",
        "http://53.tehnosila.ru",
        "http://65.tehnosila.ru",
        "http://79.tehnosila.ru",
        "http://a8.tehnosila.ru",
        "http://belgorod.tehnosila.ru",
        "http://cheboksary.tehnosila.ru",
        "http://chelyabinsk.tehnosila.ru",
        "http://cherepovets.tehnosila.ru",
        "http://ekaterinburg.tehnosila.ru",
        "http://ekt.tehnosila.ru",
        "http://enizhnekamsk.tehnosila.ru",
        "http://gatchina.tehnosila.ru",
        "http://ivanovo.tehnosila.ru",
        "http://kaluga.tehnosila.ru",
        "http://kazan.tehnosila.ru",
        "http://kemerovo.tehnosila.ru",
        "http://kingisepp.tehnosila.ru",
        "http://kolpino.tehnosila.ru",
        "http://kostroma.tehnosila.ru",
        "http://krasnodar.tehnosila.ru",
        "http://kupon-tehnosila.ru",
        "http://kursk.tehnosila.ru",
        "http://lipetsk.tehnosila.ru",
        "http://lyubertsy.tehnosila.ru",
        "http://m.tehnosila.ru",
        "http://murmansk.tehnosila.ru",
        "http://mytischi.tehnosila.ru",
        "http://nizhnevartovsk.tehnosila.ru",
        "http://nizhniy-tagil.tehnosila.ru",
        "http://noginsk.tehnosila.ru",
        "http://novgorod.tehnosila.ru",
        "http://novocherkassk.tehnosila.ru",
        "http://novosibirsk.tehnosila.ru",
        "http://omsk.tehnosila.ru",
        "http://pechora.tehnosila.ru",
        "http://penza.tehnosila.ru",
        "http://perm.tehnosila.ru",
        "http://petrozavodsk.tehnosila.ru",
        "http://podolsk.tehnosila.ru",
        "http://prokopievsk.tehnosila.ru",
        "http://pushkin.tehnosila.ru",
        "http://pyatigorsk.m.tehnosila.ru",
        "http://rostov-na-donu.tehnosila.ru",
        "http://ryazan.m.tehnosila.ru",
        "http://ryazan.tehnosila.ru",
        "http://salehard.tehnosila.ru",
        "http://samara.tehnosila.ru",
        "http://sankt-peterburg.tehnosila.ru",
        "http://sergiev-posad.tehnosila.ru",
        "http://serpuhov.tehnosila.ru",
        "http://severomorsk.tehnosila.ru",
        "http://smolensk.tehnosila.ru",
        "http://spb.tehnosila.ru",
        "http://static.tehnosila.ru",
        "http://syzran.tehnosila.ru",
        "http://tehnosila.ru",
        "http://tolyatti.tehnosila.ru",
        "http://tula.tehnosila.ru",
        "http://tver.tehnosila.ru",
        "http://tyumen.tehnosila.ru",
        "http://ufa1.tehnosila.ru",
        "http://vladimir.tehnosila.ru",
        "http://vologda.tehnosila.ru",
        "http://vorkuta.tehnosila.ru",
        "http://voronezh.tehnosila.ru",
        "http://vrj.tehnosila.ru",
        "http://vsev.tehnosila.ru",
        "http://www.tehnosila.ru",
        "http://yaroslavl.tehnosila.ru",
        "https://169.tehnosila.ru",
        "https://32.tehnosila.ru",
        "https://79.tehnosila.ru",
        "https://belgorod.tehnosila.ru",
        "https://cheboksary.tehnosila.ru",
        "https://chelyabinsk.tehnosila.ru",
        "https://ekaterinburg.tehnosila.ru",
        "https://ekt.tehnosila.ru",
        "https://gatchina.tehnosila.ru",
        "https://ivanovo.tehnosila.ru",
        "https://kaluga.tehnosila.ru",
        "https://kazan.tehnosila.ru",
        "https://kemerovo.tehnosila.ru",
        "https://kingisepp.tehnosila.ru",
        "https://kolpino.tehnosila.ru",
        "https://kostroma.tehnosila.ru",
        "https://kursk.tehnosila.ru",
        "https://m.tehnosila.ru",
        "https://murmansk.tehnosila.ru",
        "https://mytischi.tehnosila.ru",
        "https://nizhnevartovsk.tehnosila.ru",
        "https://nizhniy-tagil.tehnosila.ru",
        "https://novgorod.tehnosila.ru",
        "https://novocherkassk.tehnosila.ru",
        "https://novokuznetsk.tehnosila.ru",
        "https://novosibirsk.tehnosila.ru",
        "https://omsk.tehnosila.ru",
        "https://penza.tehnosila.ru",
        "https://perm.tehnosila.ru",
        "https://petrozavodsk.tehnosila.ru",
        "https://portal.tehnosila.ru",
        "https://prokopievsk.tehnosila.ru",
        "https://rostov-na-donu.tehnosila.ru",
        "https://ryazan.tehnosila.ru",
        "https://samara.tehnosila.ru",
        "https://sankt-peterburg.tehnosila.ru",
        "https://serpuhov.tehnosila.ru",
        "https://smolensk.tehnosila.ru",
        "https://static.tehnosila.ru",
        "https://stavropol.tehnosila.ru",
        "http://stavropol.tehnosila.ru",
        "https://syzran.tehnosila.ru",
        "https://tambov.tehnosila.ru",
        "https://tehnosila.ru",
        "https://tula.tehnosila.ru",
        "https://tver.tehnosila.ru",
        "https://tyumen.tehnosila.ru",
        "https://ulyanovsk.tehnosila.ru",
        "https://vologda.tehnosila.ru",
        "https://vorkuta.tehnosila.ru",
        "https://voronezh.tehnosila.ru",
        "https://vsev.tehnosila.ru",
        "https://www.tehnosila.ru",
        "https://yaroslavl.tehnosila.ru",
        "https://www.bormental.ru",
    };
*/
    NYT::TRichYPath path(table);
    //for (const TString &key : keys) {
    //    Y_UNUSED(key);
    //      path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey(key))));
    //}
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("1xutr.world"))));
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("wsxz001.space"))));
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("1xdkc.world"))));

    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("google.com"))));
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("google.ru"))));
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("vk.com"))));
    //path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey("youtube.com"))));

    return path;
}

void LoadMainMirrorCY(NYT::IClientBasePtr client, const TString &source, THashMap<TString, size_t> &mainMirrorCY) {
    auto reader = TTable<NProto::TIKS>(client, source).SelectFields({"Host", "MainMirror", "IKS"}).GetReader();
    for (; reader->IsValid(); reader->Next()) {
        const auto &row = reader->GetRow();
        const TString mainMirror = TString{CutHttpPrefix(row.GetMainMirror(), true)};
        const bool isHttps = (mainMirror.size() == row.GetMainMirror().size());
        size_t &cyRef = mainMirrorCY[mainMirror];
        cyRef = std::max<size_t>(cyRef, row.GetIKS());

        const TString alterMainMirror = isHttps
            ? TString{CutHttpPrefix(mainMirror)} : "https://" + mainMirror;

        auto it = mainMirrorCY.find(alterMainMirror);
        if (it != mainMirrorCY.end()) {
            cyRef = std::max<size_t>(it->second, cyRef);
            it->second = cyRef;
        }
    }
}

void LoadOwnerCY(NYT::IClientBasePtr client, const TString &source, THashMap<TString, size_t> &ownerCY) {
    auto reader = TTable<NProto::TIKS>(client, source).SelectFields({"Host", "IKS"}).GetReader();
    for (; reader->IsValid(); reader->Next()) {
        const auto &row = reader->GetRow();
        ownerCY[row.GetHost()] = row.GetIKS();
    }
}

void LoadOwnerCY(NYT::IClientBasePtr client, const TString &source, THashSet<TString> &ownerCY) {
    auto reader = TTable<NProto::TIKS>(client, source).SelectFields({"Host"}).GetReader();
    for (; reader->IsValid(); reader->Next()) {
        const auto &row = reader->GetRow();
        ownerCY.insert(row.GetHost());
    }
}

void LoadOwnersAfterJul21(THashSet<TString> &owners) {
    static const unsigned char AREAS_LST_DATA[] = {
        #include "areas_lst.inc"
    };

    static const unsigned char AREAS_LST_JUL21_DATA[] = {
        #include "areas_lst_20210701.inc"
    };

    THashSet<TString> areasLstJul21;
    {
        TArchiveReader archive(TBlob::NoCopy(AREAS_LST_JUL21_DATA, Y_ARRAY_SIZE(AREAS_LST_JUL21_DATA)));
        for (ui32 i = 0; i < archive.Count(); ++i) {
            const auto &blob = archive.ObjectBlobByKey(archive.KeyByIndex(i));
            TMemoryInput min(blob.AsCharPtr(), blob.Size());
            TString s;
            while (min.ReadLine(s)) {
                areasLstJul21.insert(s);
            }
        }
    }

    {
        TArchiveReader archive(TBlob::NoCopy(AREAS_LST_DATA, Y_ARRAY_SIZE(AREAS_LST_DATA)));
        for (ui32 i = 0; i < archive.Count(); ++i) {
            const auto &blob = archive.ObjectBlobByKey(archive.KeyByIndex(i));

            TMemoryInput min(blob.AsCharPtr(), blob.Size());
            TString s;
            while (min.ReadLine(s)) {
                if (areasLstJul21.contains(s)) {
                    continue; //skip unglued before jul 2021 domains (frozen lemur preparat)
                }
                owners.insert(s);
            }
        }
    }
}

} //namespace NIks
} //namespace NWebmaster
