#pragma once

#include <util/generic/singleton.h>
#include <library/cpp/string_utils/url/url.h>

#include <yweb/antispam/common/owner/owner.h>

namespace NWebmaster {

struct TIKSCanonizer {
    TIKSCanonizer() {
        MascotOwnerCanonizer.LoadTrueOwners();
    }

    static const TIKSCanonizer &CInstance() {
        return *Singleton<TIKSCanonizer>();
    }

    static TString GetOwner(const TString &url) {
        TString owner = CInstance().MascotOwnerCanonizer.GetUrlOwner(url);
        if (owner.StartsWith("www.")) {
            owner = owner.substr(4);
        }
        return owner;
    }

    static TString GetOwnerUrl(const TString &url) {
        const TString owner = GetOwner(url);
        const bool hasScheme = GetHttpPrefixSize(owner) != 0;
        return (hasScheme ? owner : TString::Join("http://", owner));
    }

public:
    TMascotOwnerCanonizer MascotOwnerCanonizer;
};

} //namespace NWebmaster
