#include <util/generic/hash_set.h>
#include <util/string/join.h>
#include <util/string/split.h>
#include <library/cpp/string_utils/url/url.h>

#include <wmconsole/version3/wmcutil/string.h>

#include "utils.h"

namespace NWebmaster {

bool IsIgnoredDomain(const TString &host) {
    static const THashSet<TString> IGNORE_TLD = {
        "yandex"
    };

    static const THashSet<TString> IGNORE_2LD = {
        "xn--d1acpjx3f",
        "yandex",
        "yandex-team",
        "webvisor",
    };

    static const THashSet<TString> IGNORE_DOMAINS = {
        "auto.ru",
        "adfox.ru",
        "beru.ru",
        "bringly.ru",
        "edadeal.ru",
        "foodfox.ru",
        "kinopoisk.ru",
        "partiyaedi.ru",
        "ya.ru",
        "yadi.sk",
        "yastatic.net",
    };

    const static THashSet<TString> SPEC_2LD = {
        "com", "net", "org", "co", "gov", "edu"
    };

    const TStringBuf domain = CutSchemePrefix(host);

    TVector<TStringBuf> domainParts;
    NUtils::FastSplit(domain, '.', domainParts);

    if (domainParts.size() < 2) {
        return false;
    }

    const TStringBuf tld = *domainParts.rbegin();
    const TStringBuf _2ld = *std::next(domainParts.rbegin());

    if (IGNORE_TLD.contains(tld)) {
        return true;
    }

    if (IGNORE_2LD.contains(_2ld)) {
        return true;
    }

    if (domainParts.size() > 2 && SPEC_2LD.contains(_2ld)) {
        const TStringBuf _3ld = *std::next(std::next(domainParts.rbegin()));
        return IGNORE_2LD.contains(_3ld);
    }

    return IGNORE_DOMAINS.contains(Join(".", _2ld, tld));
}

} //namespace NWebmaster
