YQL="yql --syntax-version=1"

HOST2VEC_MODEL="tools/host2vec/model/model"
HOST2VEC_TRAIN="tools/host2vec/train/train"
HOST2VEC_APPLIER="tools/host2vec/applier/applier"
IKS="tools/IKS/IKS"
FILE_WORDS=words
FILE_VECTORS=vectors
DS_SPYLOG=dataset_spy_log.txt
DS_SG=dataset_sg.txt
DS_SERP=dataset_serp.txt

_scenario() {
    MAIN    tools_user_urls: restart_on_success="20 3 * * *" retry_on_failure="20 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    tools_host2vec_update_mirrors_trie:
    MAIN    tools_host2vec_model_spy_log_dataset:       tools_host2vec_update_mirrors_trie
    MAIN    tools_host2vec_model_spy_log_train:         tools_host2vec_model_spy_log_dataset
    MAIN    tools_host2vec_model_similargroup_dataset:  tools_host2vec_model_spy_log_train
    MAIN    tools_host2vec_model_similargroup_train:    tools_host2vec_model_similargroup_dataset   restart_on_success="45 21 */7 * *"

    MAIN    tools_host2vec_model_serp_dataset:          tools_host2vec_update_mirrors_trie
    MAIN    tools_host2vec_model_serp_train:            tools_host2vec_model_serp_dataset

    MAIN    tools_host2vec_export_spy_log:
    MAIN    tools_host2vec_export_similargroup:
    MAIN    tools_host2vec_export:                      tools_host2vec_export_spy_log tools_host2vec_export_similargroup restart_on_success="15 6 */14 * *" retry_on_failure="20 6 */2 * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru

    MAIN    tools_iks_update_sources:
    MAIN    tools_iks_update_stage:                     tools_iks_update_sources
    MAIN    tools_iks_acceptance:                       tools_iks_update_stage
    MAIN    tools_iks_stage_to_prod:
    MAIN    tools_iks_update_content:
    MAIN    tools_iks_prepare_notification:             tools_iks_update_content
}

function tools_user_urls {
    ${YQL} -i tools/user_urls/user_urls.sql
}

function tools_host2vec_update_mirrors_trie {
    ${HOST2VEC_MODEL} UpdateMirrorsTrie -env-root ${ENV}
}

function tools_host2vec_model_spy_log_dataset {
    ${HOST2VEC_MODEL} DatasetSpyLog -env-root ${ENV}
    pigz -p 4 -c -d dataset_*.gz > $DS_SPYLOG
    rm dataset_*.gz
}

function tools_host2vec_model_spy_log_train {
    ${HOST2VEC_TRAIN} -train $DS_SPYLOG -min-count 100 -debug 1 -binary 2 -window 10 -size 200 -threads 16 -output-vectors $FILE_VECTORS -output $FILE_WORDS
    ${HOST2VEC_MODEL} UploadModelSpyLog -env-root ${ENV}
    rm $DS_SPYLOG
}

function tools_host2vec_model_similargroup_dataset {
    ${HOST2VEC_MODEL} DatasetSimilarGroup -env-root ${ENV}
    pigz -p 4 -c -d dataset_*.gz > $DS_SG
    rm dataset_*.gz
}

function tools_host2vec_model_similargroup_train {
    ${HOST2VEC_TRAIN} -train $DS_SG -min-count 20 -debug 1 -binary 2 -window 10 -size 200 -threads 16 -output-vectors $FILE_VECTORS -output $FILE_WORDS
    ${HOST2VEC_MODEL} UploadModelSimilarGroup -env-root ${ENV}
    rm $DS_SG
}

function tools_host2vec_model_serp_dataset {
    ${HOST2VEC_MODEL} DatasetSerp -env-root ${ENV}
    pigz -p 4 -c -d dataset_*.gz > $DS_SERP
    rm dataset_*.gz
}

function tools_host2vec_model_serp_train {
    ${HOST2VEC_TRAIN} -train $DS_SERP -min-count 20 -debug 1 -binary 2 -window 10 -size 200 -threads 16 -output-vectors $FILE_VECTORS -output $FILE_WORDS
    ${HOST2VEC_MODEL} UploadModelSerp -env-root ${ENV}
    rm $DS_SERP
}

function tools_host2vec_export_spy_log {
    EXPORT_SPYLOG=//home/webmaster/prod/export/host2vec/spylog-300
    yt --proxy hahn download //home/webmaster/prod/export/models/host2vec/words > hosts.host2vec.spylog300.txt

    ${HOST2VEC_APPLIER} \
        --server hahn.yt.yandex.net \
        --hosts hosts.host2vec.spylog300.txt \
        --words //home/webmaster/prod/export/models/host2vec/words \
        --vectors //home/webmaster/prod/export/models/host2vec/vectors \
        --limit 300 \
        --output $EXPORT_SPYLOG

    transfer-manager add-task --sync --src-cluster hahn --src-table $EXPORT_SPYLOG --dst-cluster arnold --dst-table $EXPORT_SPYLOG
}

function tools_host2vec_export_similargroup {
    EXPORT_SG=//home/webmaster/prod/export/host2vec/similargroup-300
    yt --proxy hahn download //home/webmaster/prod/export/models/host2vec_sg/words > hosts.host2vec.similargroup300.txt

    ${HOST2VEC_APPLIER} \
        --server hahn.yt.yandex.net \
        --hosts hosts.host2vec.similargroup300.txt \
        --words //home/webmaster/prod/export/models/host2vec_sg/words \
        --vectors //home/webmaster/prod/export/models/host2vec_sg/vectors \
        --limit 300 \
        --output $EXPORT_SG

    transfer-manager add-task --sync --src-cluster hahn --src-table $EXPORT_SG --dst-cluster arnold --dst-table $EXPORT_SG
}

function tools_host2vec_export {
    echo
}

function tools_iks_update_sources {
    ${IKS} UpdateSources
}

function tools_iks_update_stage {
    ${IKS} UpdateStage
}

function tools_iks_acceptance {
    ${YQL} -i tools/IKS/acceptance.sql

    yt --proxy arnold read //home/webmaster/prod/iks/stage/acceptance-stat \
        --format="<columns=[Report];enable_escaping=false>schemaful_dsv"
}

function tools_iks_stage_to_prod {
    ${IKS} StageToProd $IKS_ARGS
    EXPORT_IKS=//home/webmaster/prod/export/IKS
    transfer-manager add-task --sync --src-cluster arnold --src-table $EXPORT_IKS --dst-cluster hahn --dst-table $EXPORT_IKS
}

function tools_iks_update_content {
    ${IKS} UpdateContent
}

function tools_iks_prepare_notification {
    ${YQL} -i tools/IKS/prepare_notification.sql
}
