#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "config.h"

namespace NWebmaster {

TConfig::TConfig() {
    TCustomYTEnvironment::Instance().Init("prod");

    MR_SERVER_KWYT                      = "arnold.yt.yandex.net";
    MR_SERVER_JUPITER                   = "arnold.yt.yandex.net";
    const TString TURBO_TOP             = "turbo10k";
    const TString B2B_REPORT            = "b2b-report";

    TABLE_SOURCE_TURBO_TOP              = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT, "turbo", "fixed_top_10k");
    TABLE_SOURCE_B2B_REPORT_ROOT        = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "b2b-top", "weekly", "report", "all", "owners");

    TABLE_CMS_ROOT                      = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "cms");

    TABLE_CMS_SOURCE_ROOT               = NYTUtils::JoinPath(TABLE_CMS_ROOT, "sources");
    TABLE_CMS_DETECTED_ROOT             = NYTUtils::JoinPath(TABLE_CMS_ROOT, "detected");
    TABLE_CMS_FEATURES_ROOT             = NYTUtils::JoinPath(TABLE_CMS_ROOT, "features");

    TABLE_CMS_TURBO_TOP                 = NYTUtils::JoinPath(TABLE_CMS_SOURCE_ROOT, TURBO_TOP);
    TABLE_CMS_TURBO_TOP_FEATURES        = NYTUtils::JoinPath(TABLE_CMS_FEATURES_ROOT, TURBO_TOP);
    TABLE_CMS_TURBO_TOP_DETECTED        = NYTUtils::JoinPath(TABLE_CMS_DETECTED_ROOT, TURBO_TOP);
    TABLE_CMS_TURBO_TOP_HTML_ROOT       = NYTUtils::JoinPath(TABLE_CMS_SOURCE_ROOT, "html", TURBO_TOP);

    TABLE_CMS_B2B_REPORT                = NYTUtils::JoinPath(TABLE_CMS_SOURCE_ROOT, B2B_REPORT);
    TABLE_CMS_B2B_REPORT_FEATURES       = NYTUtils::JoinPath(TABLE_CMS_FEATURES_ROOT, B2B_REPORT);
    TABLE_CMS_B2B_REPORT_DETECTED       = NYTUtils::JoinPath(TABLE_CMS_DETECTED_ROOT, B2B_REPORT);
    TABLE_CMS_B2B_REPORT_HTML_ROOT      = NYTUtils::JoinPath(TABLE_CMS_SOURCE_ROOT, "html", B2B_REPORT);
    TABLE_CMS_B2B_REPORT_KWYT_PATHS     = NYTUtils::JoinPath(TABLE_CMS_SOURCE_ROOT, "kwyt", B2B_REPORT);

    TABLE_DS_ROOT                       = NYTUtils::JoinPath(TABLE_CMS_ROOT, "datasets");
    TABLE_DS_CONTENT                    = NYTUtils::JoinPath(TABLE_DS_ROOT, "CMS_with_mirrors.content");
    TABLE_DS_POOL_ROOT                  = NYTUtils::JoinPath(TABLE_DS_ROOT, "pools");
    TABLE_DS_POOL_ALL                   = NYTUtils::JoinPath(TABLE_DS_POOL_ROOT, "all");
    TABLE_DS_POOL_ALL_ERRORS            = NYTUtils::JoinPath(TABLE_DS_POOL_ROOT, "all-errors");
    TABLE_DS_POOL_ALL_TOKENS            = NYTUtils::JoinPath(TABLE_DS_POOL_ROOT, "all-tokens");
    TABLE_DS_POOL_ENABLED_TOKENS        = NYTUtils::JoinPath(TABLE_DS_POOL_ROOT, "enabled-tokens");
    TABLE_DS_TRAIN_ROOT                 = NYTUtils::JoinPath(TABLE_DS_ROOT, "train");
    TABLE_DS_VALIDATE_SRC               = NYTUtils::JoinPath(TABLE_CMS_ROOT, "validate-html.tokens");
    TABLE_DS_VALIDATE_DST_PARSED        = NYTUtils::JoinPath(TABLE_CMS_ROOT, "validate-html.tokens.v2");
    TABLE_DS_VALIDATE_DST_ERRORS        = NYTUtils::JoinPath(TABLE_CMS_ROOT, "validate-html.tokens.v2.errors");
}

} //namespace NWebmaster
