#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

namespace NWebmaster {

struct TConfig {
    TConfig();

    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

public:
    const float OPERATION_WEIGHT = 1.0f;

    TString MR_SERVER_KWYT;
    TString MR_SERVER_JUPITER;

    TString TABLE_SOURCE_TURBO_TOP;
    TString TABLE_SOURCE_B2B_REPORT_ROOT;

    TString TABLE_CMS_ROOT;
    TString TABLE_CMS_SOURCE_ROOT;
    TString TABLE_CMS_FEATURES_ROOT;
    TString TABLE_CMS_DETECTED_ROOT;
    TString TABLE_CMS_TURBO_TOP;
    TString TABLE_CMS_TURBO_TOP_FEATURES;
    TString TABLE_CMS_TURBO_TOP_DETECTED;
    TString TABLE_CMS_TURBO_TOP_HTML_ROOT;
    TString TABLE_CMS_B2B_REPORT;
    TString TABLE_CMS_B2B_REPORT_FEATURES;
    TString TABLE_CMS_B2B_REPORT_DETECTED;
    TString TABLE_CMS_B2B_REPORT_KWYT_PATHS;
    TString TABLE_CMS_B2B_REPORT_HTML_ROOT;

    TString TABLE_DS_ROOT;
    TString TABLE_DS_CONTENT;
    TString TABLE_DS_POOL_ROOT;
    TString TABLE_DS_POOL_ALL;
    TString TABLE_DS_POOL_ALL_ERRORS;
    TString TABLE_DS_POOL_ALL_TOKENS;
    TString TABLE_DS_POOL_ENABLED_TOKENS;
    TString TABLE_DS_TRAIN_ROOT;
    TString TABLE_DS_VALIDATE_SRC;
    TString TABLE_DS_VALIDATE_DST_PARSED;
    TString TABLE_DS_VALIDATE_DST_ERRORS;
};

} //namespace NWebmaster
