import os

from yql.api.v1.client import YqlClient
from yt.wrapper.client import Yt


def query_pool_single(input_table, output_table, cms):
    query = open("query_pool_single.sql").read()    \
        .replace("{input_table}", input_table)      \
        .replace("{output_table}", output_table)    \
        .replace("{CMS}", cms)

    return query


def query_pool_no_single(input_table, output_table, cms):
    query = open("query_pool_no-single.sql").read() \
        .replace("{input_table}", input_table)      \
        .replace("{output_table}", output_table)    \
        .replace("{CMS}", cms)

    return query


def query_train(table_pool, table_no_pool, table_pool_unknown, table_train):
    yt_client = Yt(proxy='hahn.yt.yandex.net', token=os.getenv("YT_TOKEN"))

    count_unknown = yt_client.get_attribute(table_pool_unknown, "row_count")
    count_pool = yt_client.get_attribute(table_pool, "row_count")
    count_no_pool = yt_client.get_attribute(table_no_pool, "row_count")

    query = open("query_train.sql").read()                      \
        .replace("{count_pool}", str(count_pool))               \
        .replace("{count_no_pool}", str(count_no_pool))         \
        .replace("{count_unknown}", str(count_unknown))         \
        .replace("{table_pool_unknown}", table_pool_unknown)    \
        .replace("{table_pool}", table_pool)                    \
        .replace("{table_no_pool}", table_no_pool)              \
        .replace("{table_train}", table_train)

    return query


def wait(requests):
    for req in requests:
        req.wait_progress()


def main():
    client = YqlClient()

    root = "//home/webmaster/prod/cms/datasets"
    root_pools = root + "/pools"
    root_train = root + "/train"

    pool_all = root_pools + "/all"
    pool_unknown = root_pools + "/unknown"

    pool_bitrix = root_pools + "/bitrix"
    pool_dle = root_pools + "/dle"
    pool_drupal = root_pools + "/drupal"
    pool_insales = root_pools + "/insales"
    pool_instant = root_pools + "/instant"
    pool_joomla = root_pools + "/joomla"
    pool_opencart = root_pools + "/opencart"
    pool_webasyst = root_pools + "/webasyst"
    pool_wordpress = root_pools + "/wordpress"

    pool_no_bitrix = root_pools + "/no-bitrix"
    pool_no_dle = root_pools + "/no-dle"
    pool_no_drupal = root_pools + "/no-drupal"
    pool_no_insales = root_pools + "/no-insales"
    pool_no_instant = root_pools + "/no-instant"
    pool_no_joomla = root_pools + "/no-joomla"
    pool_no_opencart = root_pools + "/no-opencart"
    pool_no_webasyst = root_pools + "/no-webasyst"
    pool_no_wordpress = root_pools + "/no-wordpress"

    train_bitrix = root_train + "/bitrix"
    train_dle = root_train + "/dle"
    train_drupal = root_train + "/drupal"
    train_insales = root_train + "/insales"
    train_instant = root_train + "/instant"
    train_joomla = root_train + "/joomla"
    train_opencart = root_train + "/opencart"
    train_webasyst = root_train + "/webasyst"
    train_wordpress = root_train + "/wordpress"

    name_bitrix = "1C-Bitrix"
    name_dle = "DataLife Engine"
    name_drupal = "Drupal"
    name_insales = "InSales"
    name_instant = "InstantCMS"
    name_joomla = "Joomla"
    name_opencart = "OpenCart"
    name_webasyst = "WebAsyst Shop-Script"
    name_wordpress = "WordPress"
    name_unknown = "?"

    wait([
        client.query(query_pool_single(pool_all, pool_unknown, name_unknown)).run(),
    ])

    wait([
        client.query(query_pool_single(pool_all, pool_bitrix,       name_bitrix)).run(),
        client.query(query_pool_single(pool_all, pool_dle,          name_dle)).run(),
        client.query(query_pool_single(pool_all, pool_drupal,       name_drupal)).run(),
        client.query(query_pool_single(pool_all, pool_insales,      name_insales)).run(),
        client.query(query_pool_single(pool_all, pool_instant,      name_instant)).run(),
        client.query(query_pool_single(pool_all, pool_joomla,       name_joomla)).run(),
        client.query(query_pool_single(pool_all, pool_opencart,     name_opencart)).run(),
        client.query(query_pool_single(pool_all, pool_webasyst,     name_webasyst)).run(),
        client.query(query_pool_single(pool_all, pool_wordpress,    name_wordpress)).run(),
    ])

    wait([
        client.query(query_pool_no_single(pool_all, pool_no_bitrix,     name_bitrix)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_dle,        name_dle)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_drupal,     name_drupal)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_insales,    name_insales)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_instant,    name_instant)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_joomla,     name_joomla)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_opencart,   name_opencart)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_webasyst,   name_webasyst)).run(),
        client.query(query_pool_no_single(pool_all, pool_no_wordpress,  name_wordpress)).run(),
    ])

    wait([
        client.query(query_train(pool_bitrix,       pool_no_bitrix,     pool_unknown,  train_bitrix)).run(),
        client.query(query_train(pool_dle,          pool_no_dle,        pool_unknown,  train_dle)).run(),
        client.query(query_train(pool_drupal,       pool_no_drupal,     pool_unknown,  train_drupal)).run(),
        client.query(query_train(pool_insales,      pool_no_insales,    pool_unknown,  train_insales)).run(),
        client.query(query_train(pool_instant,      pool_no_instant,    pool_unknown,  train_instant)).run(),
        client.query(query_train(pool_joomla,       pool_no_joomla,     pool_unknown,  train_joomla)).run(),
        client.query(query_train(pool_opencart,     pool_no_opencart,   pool_unknown,  train_opencart)).run(),
        client.query(query_train(pool_webasyst,     pool_no_webasyst,   pool_unknown,  train_webasyst)).run(),
        client.query(query_train(pool_wordpress,    pool_no_wordpress,  pool_unknown,  train_wordpress)).run(),
    ])

if __name__ == "__main__":
    main()
