use hahn;
pragma yt.MaxRowWeight="128M";

$table_train        = "{table_train}";
$count_pool         = cast(max_of({count_pool}, 10000) as float);
$count_no_pool      = cast({count_no_pool} as float);
$count_pool_unknown = cast({count_unknown} as float);

insert into $table_train
    with truncate
select
    Host,
    Path,
    Domain,
    LastAccess,
    HttpCode,
    Charset,
    HttpBody,
    HttpHeaders,
    DetectedCMS_date1,
    DetectedCMS_date2,
    DetectedCMS_date3,
    Tokens,
    1 as Target
from `{table_pool}`;

insert into $table_train
select
    Host,
    Path,
    Domain,
    LastAccess,
    HttpCode,
    Charset,
    HttpBody,
    HttpHeaders,
    DetectedCMS_date1,
    DetectedCMS_date2,
    DetectedCMS_date3,
    Tokens,
    0 as Target
from `{table_no_pool}`
sample $count_pool / $count_no_pool;

insert into $table_train
select
    Host,
    Path,
    Domain,
    LastAccess,
    HttpCode,
    Charset,
    HttpBody,
    HttpHeaders,
    DetectedCMS_date1,
    DetectedCMS_date2,
    DetectedCMS_date3,
    Tokens,
    0 as Target
from `{table_pool_unknown}`
sample $count_pool / $count_pool_unknown;
