#pragma once

#include <util/datetime/base.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

enum class EDatasetType : int
{
    SpyLog        /* "spylog" */,
    SimilarGroup  /* "similargroup" */,
    Serp          /* "serp" */,
    WatchLog      /* "watchlog" */,
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST_LOGS                     = "hahn.yt.yandex.net";
        MR_SERVER_HOST_JUPITER                  = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;
        MR_SERVER_HOST_MAIN                     = TCommonYTConfig::CInstance().MR_SERVER_HOST_JUPITER;

        FILE_MIRRORS_TRIE_YT_PATH               = "//home/webmaster/prod/export/mirrors.trie";
        TABLE_HOST2VEC_TRAIN_DATASET_ROOT       = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_INQUOTA_TEMP_ROOT, "host2vec-train");
        TABLE_HOST2VEC_TRAIN_DATASET            = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_INQUOTA_TEMP_ROOT, "host2vec-train-dataset");
        TABLE_HOST2VEC_TRAIN_DAYS               = 93;
        TABLE_HOST2VEC_TRAIN_DATASET_SERP       = TABLE_HOST2VEC_TRAIN_DATASET + "-serp";

        FILE_HOST2VEC_MODEL_SIMILARGROUP_ROOT   = TCommonYTConfig::CInstance().FILE_MODEL_HOST2VEC_SG;
        FILE_HOST2VEC_MODEL_SPY_LOG_ROOT        = TCommonYTConfig::CInstance().FILE_MODEL_HOST2VEC_SPYLOG;
        FILE_HOST2VEC_MODEL_SERP_ROOT           = TCommonYTConfig::CInstance().FILE_MODEL_HOST2VEC_SERP;
        FILE_HOST2VEC_MODEL_TABLE               = "table";
        FILE_HOST2VEC_MODEL_WORDS               = "words";
        FILE_HOST2VEC_MODEL_VECTORS             = "vectors";

        FILE_MIRRORS_TRIE_DISK_PATH = NYTUtils::GetObjectName(FILE_MIRRORS_TRIE_YT_PATH);
    }

public:
    TString MONITOR_PERFORMANCE_SUFFIX;
    TString PERIODIC_LOG_HANDLER;

    TString MR_SERVER_HOST_LOGS;
    TString MR_SERVER_HOST_JUPITER;
    TString MR_SERVER_HOST_MAIN;

    TString FILE_MIRRORS_TRIE_YT_PATH;
    TString FILE_MIRRORS_TRIE_DISK_PATH;
    TString TABLE_HOST2VEC_TRAIN_DATASET;
    TString TABLE_HOST2VEC_TRAIN_DATASET_SERP;
    TString TABLE_HOST2VEC_TRAIN_DATASET_ROOT;
    size_t TABLE_HOST2VEC_TRAIN_DAYS;

    TString FILE_HOST2VEC_MODEL_SIMILARGROUP_ROOT;
    TString FILE_HOST2VEC_MODEL_SPY_LOG_ROOT;
    TString FILE_HOST2VEC_MODEL_SERP_ROOT;
    TString FILE_HOST2VEC_MODEL_TABLE;
    TString FILE_HOST2VEC_MODEL_WORDS;
    TString FILE_HOST2VEC_MODEL_VECTORS;
};

} //namespace NWebmaster
