#pragma once

#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/wmcutil/url.h>

namespace NWebmaster {
namespace NHost2Vec {

inline bool FixHost(const TString &host, TString &fixedHost) {
    if (host.find(".") == TString::npos) {
        return false;
    }

    THttpURL parsedUrl;
    if (!NWebmaster::NUtils::ParseUrl(parsedUrl, host)) {
        return false;
    }

    const TString parsedHost = parsedUrl.PrintS(THttpURL::FlagHost);
    fixedHost = TString{NWebmaster::NUtils::FixDomainPrefix(parsedHost)};
    return true;
}

void UpdateFilteredModel(NYT::IClientBasePtr client, const TString &fltTable, const TString &fltFileWords, const TString &fltFileVectors);

} //namespace NHost2Vec
} //namespace NWebmaster
