#pragma once

#include <util/generic/singleton.h>
#include <util/generic/strbuf.h>
#include <util/system/thread.h>

#include <security/ant-secret/snooper/cpp/snooper.h>
#include <security/ant-secret/snooper/cpp/searcher.h>

#include <ydb/library/yql/public/udf/udf_helpers.h>
#include <ydb/library/yql/public/udf/udf_types.h>
#include <ydb/library/yql/public/udf/udf_value.h>
#include <ydb/library/yql/public/udf/udf_value_builder.h>

using namespace NYql::NUdf;

namespace {

struct TSecretsMask {
    using TSearcherPtr = TSimpleSharedPtr<NSnooper::TSearcher>;

    static TSecretsMask& Instance() {
        return *Singleton<TSecretsMask>();
    }

    TSearcherPtr Get() {
        const TThread::TId tid = TThread::CurrentThreadId();
        const auto it = Searchers.find(tid);

        if (it == Searchers.end()) {
            with_lock (Lock_) {
                auto &ptr = Searchers[tid];
                ptr.Reset(Snooper.NewSearcher(NSecret::ESecretType::All));
                return ptr;
            }
        }
        return it->second;
    }

    NSnooper::TSecretList Mask(TString &str) {
        return Get()->Mask(str, false);
    }

public:
    NSnooper::TSnooper Snooper;
    THashMap<TThread::TId, TSearcherPtr> Searchers;
    TMutex Lock_;
};

SIMPLE_UDF(TMaskSessionCookie, char*(char*)) {
    TString str = TString{args[0].AsStringRef()};
    TSecretsMask::Instance().Mask(str);
    return valueBuilder->NewString(str);
}

}

SIMPLE_MODULE(
    TMaskSecretsModule,
    TMaskSessionCookie
);

REGISTER_MODULES(TMaskSecretsModule)
