use arnold;

$turbo = (
    select Host, Path, true as IsTurboPage
    from `//home/webmaster/prod/import/turbo/turbo_search_urls`
);

$sitemap = (
    select Host, Path, true as FromSitemap
    from `//home/webmaster/prod/export/user-urls/from-sitemap`
);

$user = (
    select Host, Path, IsTurboPage, FromSitemap
    from (
        select Host, Path, IsTurboPage
        from $turbo
        union all
        select Host, Path, FromSitemap
        from $sitemap
    )
);

$relcanonical = (
    select SourceHost as Host, SourcePath as Path, true as RelCanonical
    from `//home/webmaster/prod/export/user-urls/rel-canonical` as r
    inner join $user as u
        on r.Host = u.Host
        and r.Path = u.Path
);

insert into `//home/webmaster/prod/export/user-urls/user-urls`
    with truncate
select 
    Host,
    Path,
    max(coalesce(IsTurboPage, false)) as IsTurboPage,
    max(coalesce(FromSitemap, false)) as FromSitemap,
    max(coalesce(RelCanonical, false)) as RelCanonical
from (
    select Host, Path, IsTurboPage, FromSitemap
    from $user
    union all
    select Host, Path, RelCanonical
    from $relcanonical
)
group by Host, Path
order by Host, Path
