YQL="yql --syntax-version=1"

_scenario() {
    MAIN    turbo_shops_prepare_rivals:
    MAIN    turbo_shops_host2vec:           turbo_shops_prepare_rivals
    MAIN    turbo_shops_merge_rivals:       turbo_shops_host2vec        restart_on_success="5 0 * * 2" retry_on_failure="5 */6 * * *"
    MAIN    turbo_scc_statuses_history:                                 restart_on_success="0 */3 * * *" retry_on_failure="0 0 * * *" mailto=kravchenko99@yandex-team.ru
    MAIN    turbo_market_settings:                                      restart_on_success="0 1 * * *"   retry_on_failure="0 1 * * *" mailto=kravchenko99@yandex-team.ru
}

function turbo_shops_prepare_rivals {
    ${YQL} -i turbo/shops/teasers_rivals_source.sql
}

function turbo_shops_host2vec {
    tools/host2vec/applier/applier                                                 \
        -h //home/webmaster/prod/turbo/shops_teasers_domains_tmp            \
        -o //home/webmaster/prod/turbo/shops_teasers_domains_host2vec_tmp   \
        -l 30
}

function turbo_shops_merge_rivals {
    ${YQL} -i turbo/shops/teasers_rivals_merge.sql
}

function turbo_scc_statuses_history {
    ${YQL} -i turbo/shops/turbo_scc_statuses_history.sql
}

function turbo_market_settings {
    ${YQL} -i turbo/shops/turbo_market_settings.sql
}
