use hahn;

$table_cur = "//home/webmaster/prod/turbo/shops_teasers_domains_host2vec";
$table_tmp = "//home/webmaster/prod/turbo/shops_teasers_domains_host2vec_tmp";

$commercial_root = "//home/webmaster/prod/b2b-top/weekly/report/all/owners";

$commercial_table = (
    select max(TableName(Path)) as Path
    from folder($commercial_root)
);

$commercial_path = $commercial_root || "/" || $commercial_table;

insert into $table_cur
select Host, Analogy, Cosine, InvCosine
from $table_tmp
where Url::GetOwner(Analogy) in (
    select Yson::ConvertToString(Name)
    from  $commercial_path
    where WeakField(Commercial, "Bool") == true
);
commit;

insert into $table_cur
    with truncate
select Host, Analogy, some(Cosine) as Cosine, some(InvCosine) as InvCosine
from $table_cur
group by Host, Analogy
order by Host, InvCosine
