use hahn ;

$data = select ToDict(AGGREGATE_LIST(Row)) as data
from (
    select
        AsTuple(status, count(*)) as Row
    from `//home/market/production/abo/turbo/premoderation_result`
    group by status
);
$banned_cnt = SELECT count(*) from `//home/market/production/abo/turbo/banned`;

$indexed_shop_domains =
  SELECT DISTINCT shop_id
  FROM `//home/turborss/production/offers/offer_base_full`
  WHERE type = 'offer'
    AND source = 'turbo+';

$market_in_progress_cnt = SELECT count(*)
FROM `//home/webmaster/prod/export/turbo/turbo-hosts` AS th
  LEFT JOIN `//home/market/production/abo/turbo/premoderation_result` AS res
    ON res.host = th.Host
WHERE Url::CutScheme(th.Host) IN COMPACT $indexed_shop_domains
  AND th.SccCheckStartDate IS NOT NULL
  AND COALESCE(res.request_timestamp, 0) < th.SccCheckStartDate;

insert into `//home/webmaster/prod/turbo/history/turbo_scc_statuses_history` with truncate
SELECT date_time, failed, pass, problem_pass, no_placement, nvl(banned, 0) as banned, NVL(in_progress, 0) as in_progress FROM
(
    SELECT date_time, failed, pass, problem_pass, no_placement, banned, in_progress from `//home/webmaster/prod/turbo/history/turbo_scc_statuses_history` UNION ALL
    select CurrentUtcDatetime() as date_time,
        nvl($data['FAILED'], 0) as failed,
        nvl($data['PASS'], 0) as pass,
        nvl($data['PROBLEM_PASS'], 0) as problem_pass,
        nvl($data['NO_PLACEMENT'], 0) as no_placement,
        $banned_cnt as banned,
        $market_in_progress_cnt as in_progress
)
order by date_time

