#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/wmcutil/config_base.h>

namespace NWebmaster {
namespace NTurbo {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        TCustomYTEnvironment::Instance().Init("prod");

        MR_TURBO_SERVER_HOST                 = "hahn.yt.yandex.net";
        MR_TURBO_BACKUP_SERVER_HOST          = "arnold.yt.yandex.net";
        TABLE_SOURCE_LOGS_ROOT               = "//home/turborss/production/logs";
        TABLE_SOURCE_FAST_LOGS_ROOT          = "//home/turborss/production.fast/logs";
        TABLE_SOURCE_YML_LOGS_ROOT           = "//home/turborss/production.yml/logs";
        TABLE_DESTINATION_ROOT               = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "import/turbo/status");
        TABLE_FEEDS_HISTORY                  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "feeds-history");
        TABLE_FEEDS_LAST_STATE               = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "feeds-last-state");
        TABLE_FEEDS_BY_DOMAIN                = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "feeds-by-domains");
        TABLE_BANS_STATE                     = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "bans-state");
        TABLE_DOMAINS_STATE                  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "domains-state");
        TABLE_DOMAINS_STATE_CHANGES_ROOT     = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "domains-state-changes");
        TABLE_TURBO_CONFIG                   = "//home/webmaster/prod/export/turbo/turbo-hosts";
        TABLE_SOURCE_API_LOGS                = "//home/turborss/api/production/wmc/logs";
        TABLE_SOURCE_API_DEBUG_LOGS          = "//home/turborss/api/production/wmc_debug/logs";
        TABLE_DESTINATION_API_LOGS_ROOT      = "//home/webmaster/prod/import/turbo/api/logs";
        TABLE_DESTINATION_API_DEBUG_LOGS_ROOT= "//home/webmaster/prod/import/turbo/api/debug_logs";
        TABLE_SOURCE_BANS                    = "//home/turborss/production/bans";
        TABLE_SOURCE_BANNED_DOCS             = "//home/turborss/production/banned_docs";
        // sources
        TABLE_SOURCE_AUTORELATED             = "//home/turborss/production/infinity.samples";
        TABLE_SOURCE_AUTOMORDA               = "//home/turborss/production/auto_morda/samples";
        TABLE_SOURCE_APP_REVIEWS_INFO        = "//home/robot-ugc/export/superapp/site_rating";
        TURBO_SOURCE_AUTOPARSER              = "//home/turbo_pages/autoparser/production/host_previews";
        TURBO_SOURCE_COMMERCE_CATEGORIES     = "//home/turborss/production/yml_listing/wmc_categories";  // aka automenu
        TURBO_SOURCE_EXPERIMENTS             = "//home/turborss/production/wmc_experiment";
        TURBO_SOURCE_LISTINGS                = "//home/turborss/production/yml_listing/wmc-listing-hosts";
        TURBO_SOURCE_MARKET_FEEDS_1          = "//home/market/production/mbi/turbo/mergefeed/latest";
        TURBO_SOURCE_MARKET_FEEDS_2          = "//home/market/testing/mbi/turbo/mergefeed/latest";
        TURBO_SOURCE_MARKET_PREMODERATION_SCC= "//home/market-quality-control/search_verticals/prod/turbo/premoderation_results";
        TURBO_SOURCE_MARKET_CATEGORIES       = "//home/market/production/abo/turbo/categories";
        TURBO_SOURCE_MARKET_BANNED_SCC       = "//home/market-quality-control/search_verticals/prod/turbo/banned";
        TURBO_SOURCE_SHOP_CATALOG_STATES     = "//home/turborss/production/yml_listing/shop_catalog_states";
        TABLE_SOURCE_TURBO_FEEDS_SETTINGS    = "//home/webmaster/prod/export/turbo/feeds_settings";
    }

public:
    TString MR_TURBO_SERVER_HOST;
    TString MR_TURBO_BACKUP_SERVER_HOST;
    TString TABLE_SOURCE_LOGS_ROOT;
    TString TABLE_SOURCE_FAST_LOGS_ROOT;
    TString TABLE_SOURCE_YML_LOGS_ROOT;
    TString TABLE_DESTINATION_ROOT;
    TString TABLE_FEEDS_HISTORY;
    TString TABLE_FEEDS_LAST_STATE;
    TString TABLE_FEEDS_BY_DOMAIN;
    TString TABLE_BANS_STATE;
    TString TABLE_DOMAINS_STATE;
    TString TABLE_DOMAINS_STATE_CHANGES_ROOT;
    TString TABLE_TURBO_CONFIG;
    TString TABLE_SOURCE_API_LOGS;
    TString TABLE_SOURCE_API_DEBUG_LOGS;
    TString TABLE_DESTINATION_API_LOGS_ROOT;
    TString TABLE_DESTINATION_API_DEBUG_LOGS_ROOT;
    TString TABLE_SOURCE_BANS;
    TString TABLE_SOURCE_BANNED_DOCS;
    // sources
    TString TABLE_SOURCE_AUTORELATED;
    TString TABLE_SOURCE_AUTOMORDA;
    TString TABLE_SOURCE_APP_REVIEWS_INFO;
    TString TURBO_SOURCE_AUTOPARSER;
    TString TURBO_SOURCE_COMMERCE_CATEGORIES;
    TString TURBO_SOURCE_EXPERIMENTS;
    TString TURBO_SOURCE_LISTINGS;
    TString TURBO_SOURCE_MARKET_FEEDS_1;
    TString TURBO_SOURCE_MARKET_FEEDS_2;
    TString TURBO_SOURCE_MARKET_PREMODERATION_SCC;
    TString TURBO_SOURCE_MARKET_CATEGORIES;
    TString TURBO_SOURCE_MARKET_BANNED_SCC;
    TString TURBO_SOURCE_SHOP_CATALOG_STATES;
    TString TABLE_SOURCE_TURBO_FEEDS_SETTINGS;
};

} //namespace NTurbo
} //namespace NWebmaster
